/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jfr.JfrMetadataTypeLibrary;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public enum JfrEvent {
    ThreadStart("jdk.ThreadStart"),
    ThreadEnd("jdk.ThreadEnd"),
    DataLoss("jdk.DataLoss"),
    ClassLoadingStatistics("jdk.ClassLoadingStatistics"),
    InitialEnvironmentVariable("jdk.InitialEnvironmentVariable"),
    InitialSystemProperty("jdk.InitialSystemProperty"),
    JavaThreadStatistics("jdk.JavaThreadStatistics"),
    JVMInformation("jdk.JVMInformation"),
    OSInformation("jdk.OSInformation"),
    PhysicalMemory("jdk.PhysicalMemory"),
    ExecutionSample("jdk.ExecutionSample"),
    NativeMethodSample("jdk.NativeMethodSample"),
    GarbageCollection("jdk.GarbageCollection"),
    GCPhasePauseEvent("jdk.GCPhasePause"),
    GCPhasePauseLevel1Event("jdk.GCPhasePauseLevel1"),
    GCPhasePauseLevel2Event("jdk.GCPhasePauseLevel2"),
    GCPhasePauseLevel3Event("jdk.GCPhasePauseLevel3"),
    GCPhasePauseLevel4Event("jdk.GCPhasePauseLevel4"),
    SafepointBegin("jdk.SafepointBegin"),
    SafepointEnd("jdk.SafepointEnd"),
    ExecuteVMOperation("jdk.ExecuteVMOperation");

    private final long id;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEvent(String name) {
        this.id = JfrMetadataTypeLibrary.lookupPlatformEvent(name);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getId() {
        return this.id;
    }
}

