/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrBuffers;
import com.oracle.svm.core.jfr.JfrConstantPool;
import com.oracle.svm.core.jfr.JfrGlobalMemory;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrSerializerSupport;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.JfrUnlockedChunkWriter;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JfrChunkWriter
implements JfrUnlockedChunkWriter {
    public static final byte[] FILE_MAGIC = new byte[]{70, 76, 82, 0};
    public static final short JFR_VERSION_MAJOR = 2;
    public static final short JFR_VERSION_MINOR = 0;
    private static final int CHUNK_SIZE_OFFSET = 8;
    public static final long METADATA_TYPE_ID = 0L;
    public static final long CONSTANT_POOL_TYPE_ID = 1L;
    private final JfrGlobalMemory globalMemory;
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean compressedInts;
    private long notificationThreshold;
    private String filename;
    private RawFileOperationSupport.RawFileDescriptor fd;
    private long chunkStartTicks;
    private long chunkStartNanos;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public JfrChunkWriter(JfrGlobalMemory globalMemory) {
        this.compressedInts = true;
        this.globalMemory = globalMemory;
    }

    @Override
    public void initialize(long maxChunkSize) {
        this.notificationThreshold = maxChunkSize;
    }

    @Override
    public JfrChunkWriter lock() {
        assert (!VMOperation.isInProgressAtSafepoint()) : "could cause deadlocks";
        this.lock.lock();
        return this;
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOpenFile() {
        return JfrChunkWriter.getFileSupport().isValid(this.fd);
    }

    public void setFilename(String filename) {
        assert (this.lock.isHeldByCurrentThread());
        this.filename = filename;
    }

    public void maybeOpenFile() {
        assert (this.lock.isHeldByCurrentThread());
        if (this.filename != null) {
            this.openFile(this.filename);
        }
    }

    public boolean openFile(String outputFile) {
        assert (this.lock.isHeldByCurrentThread());
        this.chunkStartNanos = JfrTicks.currentTimeNanos();
        this.chunkStartTicks = JfrTicks.elapsedTicks();
        this.filename = outputFile;
        this.fd = JfrChunkWriter.getFileSupport().open(this.filename, RawFileOperationSupport.FileAccessMode.READ_WRITE);
        this.writeFileHeader();
        return true;
    }

    @Uninterruptible(reason="Prevent safepoints as those could change the top pointer.")
    public boolean write(JfrBuffer buffer) {
        assert (JfrBufferAccess.isAcquired(buffer) || VMOperation.isInProgressAtSafepoint() || buffer.getBufferType() == JfrBufferType.C_HEAP);
        UnsignedWord unflushedSize = JfrBufferAccess.getUnflushedSize(buffer);
        if (unflushedSize.equal(0)) {
            return false;
        }
        boolean success = JfrChunkWriter.getFileSupport().write(this.fd, buffer.getTop(), unflushedSize);
        JfrBufferAccess.increaseTop(buffer, unflushedSize);
        if (!success) {
            return false;
        }
        return JfrChunkWriter.getFileSupport().position(this.fd).greaterThan(WordFactory.signed((long)this.notificationThreshold));
    }

    public void closeFile(byte[] metadataDescriptor, JfrConstantPool[] repositories) {
        assert (this.lock.isHeldByCurrentThread());
        JfrChangeEpochOperation op = new JfrChangeEpochOperation();
        op.enqueue();
        SignedWord constantPoolPosition = this.writeCheckpointEvent(repositories);
        SignedWord metadataPosition = this.writeMetadataEvent(metadataDescriptor);
        this.patchFileHeader(constantPoolPosition, metadataPosition);
        JfrChunkWriter.getFileSupport().close(this.fd);
        this.filename = null;
        this.fd = (RawFileOperationSupport.RawFileDescriptor)WordFactory.nullPointer();
    }

    private void writeFileHeader() {
        JfrChunkWriter.getFileSupport().write(this.fd, FILE_MAGIC);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, (short)2);
        JfrChunkWriter.getFileSupport().writeShort(this.fd, (short)0);
        assert (JfrChunkWriter.getFileSupport().position(this.fd).equal(8));
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, 0L);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.chunkStartTicks);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, JfrTicks.getTicksFrequency());
        JfrChunkWriter.getFileSupport().writeInt(this.fd, this.compressedInts ? 1 : 0);
    }

    public void patchFileHeader(SignedWord constantPoolPosition, SignedWord metadataPosition) {
        long chunkSize = JfrChunkWriter.getFileSupport().position(this.fd).rawValue();
        long durationNanos = JfrTicks.currentTimeNanos() - this.chunkStartNanos;
        JfrChunkWriter.getFileSupport().seek(this.fd, WordFactory.signed((int)8));
        JfrChunkWriter.getFileSupport().writeLong(this.fd, chunkSize);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, constantPoolPosition.rawValue());
        JfrChunkWriter.getFileSupport().writeLong(this.fd, metadataPosition.rawValue());
        JfrChunkWriter.getFileSupport().writeLong(this.fd, this.chunkStartNanos);
        JfrChunkWriter.getFileSupport().writeLong(this.fd, durationNanos);
    }

    private SignedWord writeCheckpointEvent(JfrConstantPool[] repositories) {
        SignedWord start = this.beginEvent();
        this.writeCompressedLong(1L);
        this.writeCompressedLong(JfrTicks.elapsedTicks());
        this.writeCompressedLong(0L);
        this.writeCompressedLong(0L);
        this.writeBoolean(true);
        SignedWord poolCountPos = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, 0);
        JfrConstantPool[] serializers = JfrSerializerSupport.get().getSerializers();
        int poolCount = this.writeConstantPools(serializers) + this.writeConstantPools(repositories);
        SignedWord currentPos = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().seek(this.fd, poolCountPos);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, JfrChunkWriter.makePaddedInt(poolCount));
        JfrChunkWriter.getFileSupport().seek(this.fd, currentPos);
        this.endEvent(start);
        return start;
    }

    private int writeConstantPools(JfrConstantPool[] constantPools) {
        int count = 0;
        for (JfrConstantPool constantPool : constantPools) {
            int poolCount = constantPool.write(this);
            count += poolCount;
        }
        return count;
    }

    private SignedWord writeMetadataEvent(byte[] metadataDescriptor) {
        SignedWord start = this.beginEvent();
        this.writeCompressedLong(0L);
        this.writeCompressedLong(JfrTicks.elapsedTicks());
        this.writeCompressedLong(0L);
        this.writeCompressedLong(0L);
        this.writeBytes(metadataDescriptor);
        this.endEvent(start);
        return start;
    }

    public boolean shouldRotateDisk() {
        assert (this.lock.isHeldByCurrentThread());
        return JfrChunkWriter.getFileSupport().isValid(this.fd) && JfrChunkWriter.getFileSupport().size(this.fd).greaterThan(WordFactory.signed((long)this.notificationThreshold));
    }

    public SignedWord beginEvent() {
        SignedWord start = JfrChunkWriter.getFileSupport().position(this.fd);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, 0);
        return start;
    }

    public void endEvent(SignedWord start) {
        SignedWord end = JfrChunkWriter.getFileSupport().position(this.fd);
        SignedWord writtenBytes = end.subtract(start);
        JfrChunkWriter.getFileSupport().seek(this.fd, start);
        JfrChunkWriter.getFileSupport().writeInt(this.fd, JfrChunkWriter.makePaddedInt(writtenBytes.rawValue()));
        JfrChunkWriter.getFileSupport().seek(this.fd, end);
    }

    public void writeBoolean(boolean value) {
        assert (this.lock.isHeldByCurrentThread() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.isLocked());
        this.writeByte((byte)(value ? 1 : 0));
    }

    public void writeByte(byte value) {
        assert (this.lock.isHeldByCurrentThread() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.isLocked());
        JfrChunkWriter.getFileSupport().writeByte(this.fd, value);
    }

    public void writeBytes(byte[] values) {
        assert (this.lock.isHeldByCurrentThread() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.isLocked());
        JfrChunkWriter.getFileSupport().write(this.fd, values);
    }

    public void writeCompressedInt(int value) {
        assert (this.lock.isHeldByCurrentThread() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.isLocked());
        this.writeCompressedLong((long)value & 0xFFFFFFFFL);
    }

    public void writeCompressedLong(long value) {
        assert (this.lock.isHeldByCurrentThread() || VMOperationControl.isDedicatedVMOperationThread() && this.lock.isLocked());
        long v = value;
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)v);
            return;
        }
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v | 0x80L));
        JfrChunkWriter.getFileSupport().writeByte(this.fd, (byte)(v >>> 7));
    }

    @Fold
    static RawFileOperationSupport getFileSupport() {
        return RawFileOperationSupport.bigEndian();
    }

    public void writeString(String str) {
        if (str.isEmpty()) {
            JfrChunkWriter.getFileSupport().writeByte(this.fd, StringEncoding.EMPTY_STRING.byteValue);
        } else {
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            JfrChunkWriter.getFileSupport().writeByte(this.fd, StringEncoding.UTF8_BYTE_ARRAY.byteValue);
            this.writeCompressedInt(bytes.length);
            JfrChunkWriter.getFileSupport().write(this.fd, bytes);
        }
    }

    private static int makePaddedInt(long sizeWritten) {
        return JfrNativeEventWriter.makePaddedInt(NumUtil.safeToInt((long)sizeWritten));
    }

    public long getChunkStartNanos() {
        return this.chunkStartNanos;
    }

    private class JfrChangeEpochOperation
    extends JavaVMOperation {
        protected JfrChangeEpochOperation() {
            super(VMOperationInfos.get(JfrChangeEpochOperation.class, "JFR change epoch", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            this.changeEpoch();
        }

        @Uninterruptible(reason="Prevent pollution of the current thread's thread local JFR buffer.")
        private void changeEpoch() {
            IsolateThread thread = VMThreads.firstThread();
            while (thread.isNonNull()) {
                JfrBuffer buffer = JfrThreadLocal.getJavaBuffer(thread);
                if (buffer.isNonNull()) {
                    JfrChunkWriter.this.write(buffer);
                    JfrThreadLocal.notifyEventWriter(thread);
                }
                if ((buffer = JfrThreadLocal.getNativeBuffer(thread)).isNonNull()) {
                    JfrChunkWriter.this.write(buffer);
                }
                thread = VMThreads.nextThread(thread);
            }
            JfrBuffers buffers = JfrChunkWriter.this.globalMemory.getBuffers();
            int i = 0;
            while ((long)i < JfrChunkWriter.this.globalMemory.getBufferCount()) {
                JfrBuffer buffer = buffers.addressOf(i).read();
                assert (!JfrBufferAccess.isAcquired(buffer));
                JfrChunkWriter.this.write(buffer);
                JfrBufferAccess.reinitialize(buffer);
                ++i;
            }
            JfrTraceIdEpoch.getInstance().changeEpoch();
            SubstrateJVM.getThreadRepo().registerRunningThreads();
        }
    }

    public static enum StringEncoding {
        NULL(0),
        EMPTY_STRING(1),
        CONSTANT_POOL(2),
        UTF8_BYTE_ARRAY(3),
        CHAR_ARRAY(4),
        LATIN1_BYTE_ARRAY(5);

        public byte byteValue;

        private StringEncoding(int byteValue) {
            this.byteValue = (byte)byteValue;
        }
    }
}

