/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.graal.stackvalue.StackValueRecursionDepthPhase;
import com.oracle.svm.core.graal.stackvalue.StackValueSlotAssignmentPhase;
import java.util.ListIterator;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.phases.common.FrameStateAssignmentPhase;
import org.graalvm.compiler.phases.common.LoweringPhase;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;

@AutomaticFeature
public class StackValueFeature
implements InternalFeature {
    @Override
    public void registerGraalPhases(Providers providers, SnippetReflectionProvider snippetReflection, Suites suites, boolean hosted) {
        ListIterator midTierPos = suites.getMidTier().findPhase(FrameStateAssignmentPhase.class);
        midTierPos.previous();
        midTierPos.add(new StackValueRecursionDepthPhase());
        ListIterator lowTierPos = suites.getLowTier().findPhase(LoweringPhase.class);
        lowTierPos.next();
        lowTierPos.add(new StackValueSlotAssignmentPhase());
    }
}

