/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets.aarch64;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.aarch64.AArch64ArithmeticSnippets;
import com.oracle.svm.core.graal.snippets.aarch64.AArch64NonSnippetLowerings;
import com.oracle.svm.core.graal.snippets.aarch64.PosixAArch64VaListSnippets;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
class AArch64SnippetsFeature
implements InternalFeature {
    AArch64SnippetsFeature() {
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        Predicate<ResolvedJavaMethod> mustNotAllocatePredicate = null;
        if (hosted) {
            mustNotAllocatePredicate = method -> ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate((ResolvedJavaMethod)method);
        }
        AArch64ArithmeticSnippets.registerLowerings(options, providers, lowerings);
        AArch64NonSnippetLowerings.registerLowerings(runtimeConfig, mustNotAllocatePredicate, options, providers, lowerings);
        PosixAArch64VaListSnippets.registerLowerings(options, providers, lowerings);
    }
}

