/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.option.GCRuntimeOptionKey;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class HeapParameters {
    private static final long LARGE_ARRAY_THRESHOLD_SENTINEL_VALUE = 0L;
    private static final int ALIGNED_HEAP_CHUNK_FRACTION_FOR_LARGE_ARRAY_THRESHOLD = 8;
    private static final UnsignedWord producedHeapChunkZapInt;
    private static final UnsignedWord producedHeapChunkZapWord;
    private static final UnsignedWord consumedHeapChunkZapInt;
    private static final UnsignedWord consumedHeapChunkZapWord;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    static void initialize() {
        if (!SubstrateUtil.isPowerOf2(HeapParameters.getAlignedHeapChunkSize().rawValue())) {
            throw UserError.abort("AlignedHeapChunkSize (%d) should be a power of 2.", HeapParameters.getAlignedHeapChunkSize().rawValue());
        }
        if (!HeapParameters.getLargeArrayThreshold().belowOrEqual(HeapParameters.getAlignedHeapChunkSize())) {
            throw UserError.abort("LargeArrayThreshold (%d) should be below or equal to AlignedHeapChunkSize (%d).", HeapParameters.getLargeArrayThreshold().rawValue(), HeapParameters.getAlignedHeapChunkSize().rawValue());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getProducedHeapChunkZapWord() {
        return (Word)producedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getProducedHeapChunkZapInt() {
        return (int)producedHeapChunkZapInt.rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Word getConsumedHeapChunkZapWord() {
        return (Word)consumedHeapChunkZapWord;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int getConsumedHeapChunkZapInt() {
        return (int)consumedHeapChunkZapInt.rawValue();
    }

    @Fold
    public static int getMaxSurvivorSpaces() {
        return Options.MaxSurvivorSpaces.getValue();
    }

    public static void setMaximumHeapSize(UnsignedWord value) {
        SubstrateGCOptions.MaxHeapSize.update(value.rawValue());
    }

    public static void setMinimumHeapSize(UnsignedWord value) {
        SubstrateGCOptions.MinHeapSize.update(value.rawValue());
    }

    public static void setMaximumHeapFree(UnsignedWord bytes) {
        Options.MaxHeapFree.update(bytes.rawValue());
    }

    public static UnsignedWord getMaximumHeapFree() {
        return WordFactory.unsigned((long)Options.MaxHeapFree.getValue());
    }

    static int getMaximumYoungGenerationSizePercent() {
        int result = Options.MaximumYoungGenerationSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumYoungGenerationSizePercent should be in [0 ..100]");
        return result;
    }

    static int getMaximumHeapSizePercent() {
        int result = Options.MaximumHeapSizePercent.getValue();
        VMError.guarantee(result >= 0 && result <= 100, "MaximumHeapSizePercent should be in [0 ..100]");
        return result;
    }

    @Fold
    public static UnsignedWord getAlignedHeapChunkSize() {
        return WordFactory.unsigned((long)Options.AlignedHeapChunkSize.getValue());
    }

    @Fold
    static UnsignedWord getAlignedHeapChunkAlignment() {
        return HeapParameters.getAlignedHeapChunkSize();
    }

    @Fold
    public static UnsignedWord getLargeArrayThreshold() {
        long largeArrayThreshold = Options.LargeArrayThreshold.getValue();
        if (0L == largeArrayThreshold) {
            return HeapParameters.getAlignedHeapChunkSize().unsignedDivide(8);
        }
        return WordFactory.unsigned((long)Options.LargeArrayThreshold.getValue());
    }

    public static boolean getZapProducedHeapChunks() {
        return Options.ZapChunks.getValue() != false || Options.ZapProducedHeapChunks.getValue() != false;
    }

    public static boolean getZapConsumedHeapChunks() {
        return Options.ZapChunks.getValue() != false || Options.ZapConsumedHeapChunks.getValue() != false;
    }

    static {
        Word.ensureInitialized();
        producedHeapChunkZapInt = WordFactory.unsigned((int)-1163019586);
        producedHeapChunkZapWord = producedHeapChunkZapInt.shiftLeft(32).or(producedHeapChunkZapInt);
        consumedHeapChunkZapInt = WordFactory.unsigned((int)-559038737);
        consumedHeapChunkZapWord = consumedHeapChunkZapInt.shiftLeft(32).or(consumedHeapChunkZapInt);
    }

    public static final class TestingBackDoor {
        private TestingBackDoor() {
        }

        public static long getUnalignedObjectSize() {
            return HeapParameters.getLargeArrayThreshold().rawValue();
        }
    }

    public static final class Options {
        public static final RuntimeOptionKey<Integer> MaximumHeapSizePercent = new GCRuntimeOptionKey<Integer>(80, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Integer> MaximumYoungGenerationSizePercent = new GCRuntimeOptionKey<Integer>(10, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final HostedOptionKey<Long> AlignedHeapChunkSize = new HostedOptionKey<Long>(Long.valueOf(0x100000L)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
                int multiple = 4096;
                UserError.guarantee(newValue > 0L && newValue % (long)multiple == 0L, "%s value must be a multiple of %d.", this.getName(), multiple);
            }
        };
        public static final HostedOptionKey<Long> LargeArrayThreshold = new HostedOptionKey<Long>(0L);
        public static final HostedOptionKey<Boolean> ZapChunks = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> ZapProducedHeapChunks = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> ZapConsumedHeapChunks = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Boolean> TraceHeapChunks = new RuntimeOptionKey<Boolean>(false, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final HostedOptionKey<Integer> MaxSurvivorSpaces = new HostedOptionKey<Integer>(null){

            public Integer getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                Integer value = (Integer)values.get((Object)this);
                UserError.guarantee(value == null || value >= 0, "%s value must be greater than or equal to 0", this.getName());
                return CollectionPolicy.getMaxSurvivorSpaces(value);
            }

            public Integer getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
        public static final RuntimeOptionKey<Boolean> CollectYoungGenerationSeparately = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Long> MaxHeapFree = new RuntimeOptionKey<Long>(0L, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);

        private Options() {
        }
    }
}

