/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.annotate;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.CONSTRUCTOR})
@Platforms(value={Platform.HOSTED_ONLY.class})
public @interface RestrictHeapAccess {
    public Access access();

    public String reason();

    public static enum Access {
        UNRESTRICTED,
        NO_ALLOCATION;


        public boolean isMoreRestrictiveThan(Access other) {
            return this.ordinal() > other.ordinal();
        }
    }
}

