/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.VMInspectionStartupHook;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import java.util.function.BooleanSupplier;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class VMInspection
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspection.isEnabled() || VMInspectionOptions.DumpThreadStacksOnSignal.getValue() != false;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(new VMInspectionStartupHook());
    }

    @Fold
    public static boolean isEnabled() {
        return VMInspectionOptions.AllowVMInspection.getValue();
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return VMInspection.isEnabled();
        }
    }
}

