/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.heap.VMOperationInfos;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import sun.misc.Signal;
import sun.misc.SignalHandler;

class DumpAllStacks
implements SignalHandler {
    DumpAllStacks() {
    }

    static void install() {
        Signal.handle(Platform.includedIn(Platform.WINDOWS.class) ? new Signal("BREAK") : new Signal("QUIT"), new DumpAllStacks());
    }

    @Override
    public void handle(Signal arg0) {
        DumpAllStacksOperation vmOp = new DumpAllStacksOperation();
        vmOp.enqueue();
    }

    private static class DumpAllStacksOperation
    extends JavaVMOperation {
        DumpAllStacksOperation() {
            super(VMOperationInfos.get(DumpAllStacksOperation.class, "Dump all stacks", VMOperation.SystemEffect.SAFEPOINT));
        }

        @Override
        protected void operate() {
            Log log = Log.log();
            log.string("Full thread dump:").newline().newline();
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    try {
                        DumpAllStacksOperation.dumpStack(log, vmThread);
                    }
                    catch (Exception e) {
                        log.string("Exception during dumpStack: ").string(e.getClass().getName()).newline();
                        log.string(e.getMessage()).newline();
                    }
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
            log.flush();
        }

        private static void dumpStack(Log log, IsolateThread vmThread) {
            Thread javaThread = PlatformThreads.fromVMThread(vmThread);
            if (javaThread != null) {
                log.character('\"').string(javaThread.getName()).character('\"');
                log.string(" #").signed(javaThread.getId());
                if (javaThread.isDaemon()) {
                    log.string(" daemon");
                }
            } else {
                log.string("(no Java thread)");
            }
            log.string(" tid=0x").zhex(vmThread.rawValue());
            if (javaThread != null) {
                log.string(" state=").string(javaThread.getState().name());
            }
            log.newline();
            log.indent(true);
            JavaStackWalker.walkThread(vmThread, ThreadStackPrinter.StackFramePrintVisitor.SINGLETON, log);
            log.indent(false);
        }
    }
}

