/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrEarlier;
import com.oracle.svm.core.jdk.JDK17OrLater;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.reflect.hosted.FieldOffsetComputer;
import com.oracle.svm.reflect.hosted.ReflectionMetadataComputer;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_FieldAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.util.GuardedAnnotationAccess;

@TargetClass(value=Field.class)
public final class Target_java_lang_reflect_Field {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor fieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor overrideFieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotationsComputer.class)
    byte[] annotations;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldOffsetComputer.class)
    public int offset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldDeletionReasonComputer.class)
    String deletedReason;
    @Alias
    boolean override;
    @Alias
    Target_java_lang_reflect_Field root;

    @Alias
    native Target_java_lang_reflect_Field copy();

    @Alias
    native Target_jdk_internal_reflect_FieldAccessor acquireFieldAccessor(boolean var1);

    @Alias
    @TargetElement(name="<init>", onlyWith={JDK17OrLater.class})
    native void constructorJDK17OrLater(Class<?> var1, String var2, Class<?> var3, int var4, boolean var5, int var6, String var7, byte[] var8);

    @Alias
    @TargetElement(name="<init>", onlyWith={JDK11OrEarlier.class})
    native void constructorJDK11OrEarlier(Class<?> var1, String var2, Class<?> var3, int var4, int var5, String var6, byte[] var7);

    @Substitute
    Target_jdk_internal_reflect_FieldAccessor getFieldAccessor(Object obj) {
        Target_jdk_internal_reflect_FieldAccessor accessor;
        boolean ov = this.override;
        Target_jdk_internal_reflect_FieldAccessor target_jdk_internal_reflect_FieldAccessor = accessor = ov ? this.overrideFieldAccessor : this.fieldAccessor;
        if (accessor != null) {
            return accessor;
        }
        if (this.deletedReason != null) {
            Field field = SubstrateUtil.cast(this, Field.class);
            throw VMError.unsupportedFeature("Unsupported field " + field.getDeclaringClass().getTypeName() + "." + field.getName() + " is reachable: " + this.deletedReason);
        }
        return this.acquireFieldAccessor(ov);
    }

    @Substitute
    private byte[] getTypeAnnotationBytes0() {
        return SubstrateUtil.cast((Object)this, Target_java_lang_reflect_AccessibleObject.class).typeAnnotations;
    }

    static class AnnotationsComputer
    extends ReflectionMetadataComputer {
        AnnotationsComputer() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            return ((NativeImageCodeCache.ReflectionMetadataEncoder)ImageSingletons.lookup(NativeImageCodeCache.ReflectionMetadataEncoder.class)).getAnnotationsEncoding((AccessibleObject)receiver);
        }
    }

    public static final class FieldDeletionReasonComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public RecomputeFieldValue.ValueAvailability valueAvailability() {
            return RecomputeFieldValue.ValueAvailability.BeforeAnalysis;
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            ResolvedJavaField field = metaAccess.lookupJavaField((Field)receiver);
            Delete annotation = (Delete)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)field, Delete.class);
            return annotation != null ? annotation.value() : null;
        }
    }
}

