/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_AccessibleObject;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Constructor;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Executable;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Method;

class ReflectionHelper {
    ReflectionHelper() {
    }

    static Target_java_lang_reflect_Executable getHolder(Target_java_lang_reflect_Executable executable) {
        Target_java_lang_reflect_Executable holder = ReflectionHelper.getRoot(executable);
        if (holder == null) {
            holder = executable;
        }
        return holder;
    }

    static Target_java_lang_reflect_Method getHolder(Target_java_lang_reflect_Method method) {
        Target_java_lang_reflect_Method holder = ReflectionHelper.getRoot(method);
        if (holder == null) {
            holder = method;
        }
        return holder;
    }

    static Target_java_lang_reflect_Constructor getHolder(Target_java_lang_reflect_Constructor constructor) {
        Target_java_lang_reflect_Constructor holder = ReflectionHelper.getRoot(constructor);
        if (holder == null) {
            holder = constructor;
        }
        return holder;
    }

    static Target_java_lang_reflect_Field getHolder(Target_java_lang_reflect_Field field) {
        Target_java_lang_reflect_Field holder = field.root;
        if (holder == null) {
            holder = field;
        }
        return holder;
    }

    static <T> T requireNonNull(T object, String errorMessage) {
        if (object == null) {
            throw VMError.shouldNotReachHere(errorMessage);
        }
        return object;
    }

    private static Target_java_lang_reflect_Executable getRoot(Target_java_lang_reflect_Executable executable) {
        return SubstrateUtil.cast(SubstrateUtil.cast(executable, Target_java_lang_reflect_AccessibleObject.class).getRoot(), Target_java_lang_reflect_Executable.class);
    }

    private static Target_java_lang_reflect_Method getRoot(Target_java_lang_reflect_Method method) {
        return SubstrateUtil.cast(SubstrateUtil.cast(method, Target_java_lang_reflect_AccessibleObject.class).getRoot(), Target_java_lang_reflect_Method.class);
    }

    private static Target_java_lang_reflect_Constructor getRoot(Target_java_lang_reflect_Constructor constructor) {
        return SubstrateUtil.cast(SubstrateUtil.cast(constructor, Target_java_lang_reflect_AccessibleObject.class).getRoot(), Target_java_lang_reflect_Constructor.class);
    }
}

