/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

@AutomaticFeature
public class MethodHandleFeature
implements Feature {
    private Set<MethodHandle> seenMethodHandles;
    private Class<?> directMethodHandleClass;
    private Class<?> boundMethodHandleClass;
    private Class<?> delegatingMethodHandleClass;
    private Method getDelegatingMethodHandleTarget;
    private Method methodHandleInternalMemberName;
    private Method memberNameGetDeclaringClass;
    private Method memberNameGetName;
    private Method memberNameIsMethod;
    private Method memberNameIsConstructor;
    private Method memberNameIsField;
    private Method memberNameGetParameterTypes;
    private Field methodHandleInternalForm;
    private Field lambdaFormNames;
    private Field lambdaFormArity;
    private Field nameFunction;
    private Field namedFunctionMemberName;
    private Field lambdaFormLFIdentity;
    private Field lambdaFormLFZero;
    private Field lambdaFormNFIdentity;
    private Field lambdaFormNFZero;
    private Field typedAccessors;
    private Field classSpecializerCache;
    private Class<?> lambdaFormClass;
    private Class<?> classSpecializerClass;
    private Class<?> arrayAccessorClass;

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.seenMethodHandles = ConcurrentHashMap.newKeySet();
        this.directMethodHandleClass = access.findClassByName("java.lang.invoke.DirectMethodHandle");
        this.boundMethodHandleClass = access.findClassByName("java.lang.invoke.BoundMethodHandle");
        this.delegatingMethodHandleClass = access.findClassByName("java.lang.invoke.DelegatingMethodHandle");
        this.getDelegatingMethodHandleTarget = ReflectionUtil.lookupMethod(this.delegatingMethodHandleClass, (String)"getTarget", (Class[])new Class[0]);
        this.methodHandleInternalMemberName = ReflectionUtil.lookupMethod(MethodHandle.class, (String)"internalMemberName", (Class[])new Class[0]);
        this.methodHandleInternalForm = ReflectionUtil.lookupField(MethodHandle.class, (String)"form");
        Class memberNameClass = access.findClassByName("java.lang.invoke.MemberName");
        this.memberNameGetDeclaringClass = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"getDeclaringClass", (Class[])new Class[0]);
        this.memberNameGetName = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"getName", (Class[])new Class[0]);
        this.memberNameIsMethod = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isMethod", (Class[])new Class[0]);
        this.memberNameIsConstructor = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isConstructor", (Class[])new Class[0]);
        this.memberNameIsField = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"isField", (Class[])new Class[0]);
        this.memberNameGetParameterTypes = ReflectionUtil.lookupMethod((Class)memberNameClass, (String)"getParameterTypes", (Class[])new Class[0]);
        this.lambdaFormClass = access.findClassByName("java.lang.invoke.LambdaForm");
        this.lambdaFormNames = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"names");
        this.lambdaFormArity = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"arity");
        Class nameClass = access.findClassByName("java.lang.invoke.LambdaForm$Name");
        this.nameFunction = ReflectionUtil.lookupField((Class)nameClass, (String)"function");
        Class namedFunctionClass = access.findClassByName("java.lang.invoke.LambdaForm$NamedFunction");
        this.namedFunctionMemberName = ReflectionUtil.lookupField((Class)namedFunctionClass, (String)"member");
        this.lambdaFormLFIdentity = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"LF_identity");
        this.lambdaFormLFZero = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"LF_zero");
        this.lambdaFormNFIdentity = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"NF_identity");
        this.lambdaFormNFZero = ReflectionUtil.lookupField(this.lambdaFormClass, (String)"NF_zero");
        this.classSpecializerClass = access.findClassByName("java.lang.invoke.ClassSpecializer");
        this.arrayAccessorClass = access.findClassByName("java.lang.invoke.MethodHandleImpl$ArrayAccessor");
        this.typedAccessors = ReflectionUtil.lookupField(this.arrayAccessorClass, (String)"TYPED_ACCESSORS");
        this.classSpecializerCache = ReflectionUtil.lookupField(this.classSpecializerClass, (String)"cache");
        access.registerObjectReplacer(this::registerMethodHandle);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"createFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplConstantHandlesForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"makeConstantHandle", (Class[])new Class[]{Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplCountingWrapperFunctionsForReflection, new Object[]{access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper")});
        access.registerReachabilityHandler(MethodHandleFeature::registerInvokersFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.Invokers"), (String)"createFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionBoxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"boxExact", (Class[])new Class[]{Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionUnboxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"unbox", (Class[])new Class[]{Wrapper.class, Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionConvertFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"convertPrimitive", (Class[])new Class[]{Wrapper.class, Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionIgnoreForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[0])});
        access.registerClassInitializerReachabilityHandler(MethodHandleFeature::registerDelegatingMHFunctionsForReflection, access.findClassByName("java.lang.invoke.DelegatingMethodHandle"));
        access.registerReachabilityHandler(MethodHandleFeature::registerCallSiteGetTargetForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTargetHandle", (Class[])new Class[0])});
        access.registerReachabilityHandler(MethodHandleFeature::registerUninitializedCallSiteForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSiteHandle", (Class[])new Class[0])});
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::registerVarHandleMethodsForReflection, access.findClassByName("java.lang.invoke.VarHandle"));
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::scanBoundMethodHandle, this.boundMethodHandleClass);
    }

    private static void registerMHImplFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"checkSpreadArgument", (Class[])new Class[]{Object.class, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"guardWithCatch", (Class[])new Class[]{MethodHandle.class, Class.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"tryFinally", (Class[])new Class[]{MethodHandle.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"loop", (Class[])new Class[]{access.findClassByName("[Ljava.lang.invoke.LambdaForm$BasicType;"), access.findClassByName("java.lang.invoke.MethodHandleImpl$LoopClauses"), Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"throwException", (Class[])new Class[]{Throwable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"profileBoolean", (Class[])new Class[]{Boolean.TYPE, int[].class})});
    }

    private static void registerMHImplConstantHandlesForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        if (JavaVersionUtil.JAVA_SPEC <= 11) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"copyAsPrimitiveArray", (Class[])new Class[]{access.findClassByName("sun.invoke.util.Wrapper"), Object[].class})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"identity", (Class[])new Class[]{Object[].class})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"fillNewArray", (Class[])new Class[]{Integer.class, Object[].class})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"fillNewTypedArray", (Class[])new Class[]{Object[].class, Integer.class, Object[].class})});
        }
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"selectAlternative", (Class[])new Class[]{Boolean.TYPE, MethodHandle.class, MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopPredicate", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopStep", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"initIterator", (Class[])new Class[]{Iterable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iteratePredicate", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iterateNext", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(Array.class, (String)"newInstance", (Class[])new Class[]{Class.class, Integer.TYPE})});
    }

    private static void registerMHImplCountingWrapperFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper"), (String)"maybeStopCounting", (Class[])new Class[]{Object.class})});
    }

    private static void registerInvokersFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class invokersClazz = access.findClassByName("java.lang.invoke.Invokers");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkExactType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkGenericType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"getCallSiteTarget", (Class[])new Class[]{CallSite.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkCustomized", (Class[])new Class[]{MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleGenericType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleExactType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
        if (JavaVersionUtil.JAVA_SPEC >= 17) {
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"directVarHandleTarget", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle")})});
        }
    }

    private static void registerValueConversionBoxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("box" + type.wrapperSimpleName()), (Class[])new Class[]{type.primitiveType()})});
        }
    }

    private static void registerValueConversionUnboxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{type.wrapperType()})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{Object.class, Boolean.TYPE})});
        }
    }

    private static void registerValueConversionConvertFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper src : Wrapper.values()) {
            for (Wrapper dest : Wrapper.values()) {
                if (src == dest || !src.primitiveType().isPrimitive() || src == Wrapper.VOID || !dest.primitiveType().isPrimitive() || dest == Wrapper.VOID) continue;
                RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)MethodHandleFeature.valueConverterName(src, dest), (Class[])new Class[]{src.primitiveType()})});
            }
        }
    }

    private static String valueConverterName(Wrapper src, Wrapper dest) {
        String srcType = src.primitiveSimpleName();
        String destType = dest.primitiveSimpleName();
        return srcType + "To" + destType.substring(0, 1).toUpperCase() + destType.substring(1);
    }

    private static void registerValueConversionIgnoreForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[]{Object.class})});
    }

    private static void registerDelegatingMHFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class delegatingMHClazz = access.findClassByName("java.lang.invoke.DelegatingMethodHandle");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)delegatingMHClazz, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerCallSiteGetTargetForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerUninitializedCallSiteForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSite", (Class[])new Class[]{Object[].class})});
    }

    private static void registerVarHandleMethodsForReflection(Feature.DuringAnalysisAccess access, Class<?> subtype) {
        if (subtype.getPackage().getName().equals("java.lang.invoke") && subtype != access.findClassByName("java.lang.invoke.VarHandle")) {
            RuntimeReflection.register((Executable[])subtype.getDeclaredMethods());
        }
    }

    private Object registerMethodHandle(Object obj) {
        if (!BuildPhaseProvider.isAnalysisFinished()) {
            this.registerMethodHandleRecurse(obj);
        }
        return obj;
    }

    private void registerMethodHandleRecurse(Object obj) {
        if (!(obj instanceof MethodHandle) || this.seenMethodHandles.contains(obj)) {
            return;
        }
        MethodHandle handle = (MethodHandle)obj;
        this.seenMethodHandles.add(handle);
        if (this.directMethodHandleClass.isAssignableFrom(handle.getClass())) {
            try {
                this.registerMemberName(this.methodHandleInternalMemberName.invoke((Object)handle, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (this.boundMethodHandleClass.isAssignableFrom(handle.getClass())) {
            for (Field field : handle.getClass().getDeclaredFields()) {
                if (!field.getName().startsWith("arg")) continue;
                RuntimeReflection.register((Field[])new Field[]{field});
                if (field.getType().isPrimitive()) continue;
                try {
                    field.setAccessible(true);
                    this.registerMethodHandleRecurse(field.get(handle));
                }
                catch (IllegalAccessException e) {
                    throw VMError.shouldNotReachHere(e);
                }
            }
            try {
                int arity;
                Object form = this.methodHandleInternalForm.get(handle);
                Object[] names = (Object[])this.lambdaFormNames.get(form);
                for (int i = arity = ((Integer)this.lambdaFormArity.get(form)).intValue(); i < names.length; ++i) {
                    Object function = this.nameFunction.get(names[i]);
                    if (function == null) continue;
                    this.registerMemberName(this.namedFunctionMemberName.get(function));
                }
            }
            catch (IllegalAccessException e) {
                VMError.shouldNotReachHere(e);
            }
        } else if (this.delegatingMethodHandleClass.isAssignableFrom(handle.getClass())) {
            try {
                MethodHandle wrappedHandle = (MethodHandle)this.getDelegatingMethodHandleTarget.invoke((Object)handle, new Object[0]);
                this.registerMethodHandleRecurse(wrappedHandle);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    private void registerMemberName(Object memberName) {
        try {
            Class[] paramTypes;
            Class declaringClass = (Class)this.memberNameGetDeclaringClass.invoke(memberName, new Object[0]);
            boolean isMethod = (Boolean)this.memberNameIsMethod.invoke(memberName, new Object[0]);
            boolean isConstructor = (Boolean)this.memberNameIsConstructor.invoke(memberName, new Object[0]);
            boolean isField = (Boolean)this.memberNameIsField.invoke(memberName, new Object[0]);
            String name = isMethod || isField ? (String)this.memberNameGetName.invoke(memberName, new Object[0]) : null;
            Class[] classArray = paramTypes = isMethod || isConstructor ? (Class[])this.memberNameGetParameterTypes.invoke(memberName, new Object[0]) : null;
            if (isMethod) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredMethod(name, paramTypes)});
            } else if (isConstructor) {
                RuntimeReflection.register((Executable[])new Executable[]{declaringClass.getDeclaredConstructor(paramTypes)});
            } else if (isField) {
                RuntimeReflection.register((Field[])new Field[]{declaringClass.getDeclaredField(name)});
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException declaringClass) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.rescanRoot(this.lambdaFormLFIdentity);
        access.rescanRoot(this.lambdaFormLFZero);
        access.rescanRoot(this.lambdaFormNFIdentity);
        access.rescanRoot(this.lambdaFormNFZero);
        access.rescanRoot(this.typedAccessors);
    }

    private static void scanBoundMethodHandle(Feature.DuringAnalysisAccess a, Class<?> bmhSubtype) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        Field bmhSpeciesField = ReflectionUtil.lookupField((boolean)true, bmhSubtype, (String)"BMH_SPECIES");
        if (bmhSpeciesField != null) {
            access.rescanRoot(bmhSpeciesField);
        }
    }
}

