/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.jni.JNIJavaCallTrampolines;
import com.oracle.svm.jni.access.JNIAccessFeature;
import com.oracle.svm.jni.hosted.JNICallTrampolineMethod;
import com.oracle.svm.jni.hosted.JNINativeCallWrapperMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

class JNINativeCallWrapperSubstitutionProcessor
extends SubstitutionProcessor {
    private final MetaAccessProvider originalMetaAccess;
    private final ResolvedJavaType trampolinesType;
    private final Map<ResolvedJavaMethod, JNINativeCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, JNINativeCallWrapperMethod>();

    JNINativeCallWrapperSubstitutionProcessor(FeatureImpl.DuringSetupAccessImpl access) {
        this.originalMetaAccess = access.getMetaAccess().getWrapped();
        this.trampolinesType = this.originalMetaAccess.lookupJavaType(JNIJavaCallTrampolines.class);
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        assert (method.isNative()) : "Must have been registered as a native substitution processor";
        if (method instanceof JNINativeCallWrapperMethod) {
            return method;
        }
        if (method.getDeclaringClass().equals(this.trampolinesType)) {
            return JNIAccessFeature.singleton().getOrCreateCallTrampolineMethod(this.originalMetaAccess, method.getName());
        }
        return this.callWrappers.computeIfAbsent(method, JNINativeCallWrapperMethod::new);
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof JNINativeCallWrapperMethod) {
            return ((JNINativeCallWrapperMethod)method).getOriginal();
        }
        if (method instanceof JNICallTrampolineMethod) {
            return ((JNICallTrampolineMethod)method).getOriginal();
        }
        return method;
    }
}

