/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.jni.JNIGlobalHandles;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIObjectRefType;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class JNIImageHeapHandles {
    private static final int OBJ_OFFSET_BITS_COUNT = 32;
    private static final Word OBJ_OFFSET_BITS_MASK = (Word)WordFactory.unsigned((long)0xFFFFFFFFL);
    private static final SignedWord LOCAL_RANGE_MIN = WordFactory.signed((int)1).shiftLeft(32);
    private static final SignedWord GLOBAL_RANGE_MIN = WordFactory.signed((int)2).shiftLeft(32);
    private static final SignedWord WEAK_GLOBAL_RANGE_MIN = WordFactory.signed((int)3).shiftLeft(32);
    private static final SignedWord ENTIRE_RANGE_MIN = LOCAL_RANGE_MIN;
    private static final SignedWord ENTIRE_RANGE_MAX = WEAK_GLOBAL_RANGE_MIN.add((SignedWord)OBJ_OFFSET_BITS_MASK);

    JNIImageHeapHandles() {
    }

    static boolean isInImageHeap(Object target) {
        return target != null && Heap.getHeap().isInImageHeap(target);
    }

    static boolean isInRange(JNIObjectHandle handle) {
        SignedWord handleValue = (SignedWord)handle;
        return handleValue.greaterOrEqual(ENTIRE_RANGE_MIN) && handleValue.lessOrEqual(ENTIRE_RANGE_MAX);
    }

    static JNIObjectHandle asLocal(Object target) {
        assert (JNIImageHeapHandles.isInImageHeap(target));
        SignedWord base = (SignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate());
        Word offset = Word.objectToUntrackedPointer((Object)target).subtract(base);
        assert (offset.and((SignedWord)OBJ_OFFSET_BITS_MASK).equal((SignedWord)offset)) : "does not fit in range";
        return (JNIObjectHandle)LOCAL_RANGE_MIN.add((SignedWord)offset);
    }

    static JNIObjectHandle toLocal(JNIObjectHandle handle) {
        return JNIImageHeapHandles.toRange(handle, LOCAL_RANGE_MIN);
    }

    static JNIObjectHandle toGlobal(JNIObjectHandle handle) {
        return JNIImageHeapHandles.toRange(handle, GLOBAL_RANGE_MIN);
    }

    static JNIObjectHandle toWeakGlobal(JNIObjectHandle handle) {
        return JNIImageHeapHandles.toRange(handle, WEAK_GLOBAL_RANGE_MIN);
    }

    private static JNIObjectHandle toRange(JNIObjectHandle handle, SignedWord rangeMin) {
        assert (JNIImageHeapHandles.isInRange(handle)) : "assert isInRange(handle) failed";
        return (JNIObjectHandle)((SignedWord)handle).and((SignedWord)OBJ_OFFSET_BITS_MASK).add(rangeMin);
    }

    static <T> T getObject(JNIObjectHandle handle) {
        assert (JNIImageHeapHandles.isInRange(handle));
        UnsignedWord base = (UnsignedWord)Isolates.getHeapBase(CurrentIsolate.getIsolate());
        Pointer offset = ((Pointer)handle).and((UnsignedWord)OBJ_OFFSET_BITS_MASK).add(base);
        Object obj = offset.toObjectNonNull();
        assert (JNIImageHeapHandles.isInImageHeap(obj));
        return (T)obj;
    }

    static JNIObjectRefType getHandleType(JNIObjectHandle handle) {
        assert (JNIImageHeapHandles.isInRange(handle));
        SignedWord handleValue = (SignedWord)handle;
        if (handleValue.greaterOrEqual(WEAK_GLOBAL_RANGE_MIN)) {
            return JNIObjectRefType.WeakGlobal;
        }
        if (handleValue.greaterOrEqual(GLOBAL_RANGE_MIN)) {
            return JNIObjectRefType.Global;
        }
        if (handleValue.greaterOrEqual(LOCAL_RANGE_MIN)) {
            return JNIObjectRefType.Local;
        }
        return JNIObjectRefType.Invalid;
    }

    static {
        assert (ENTIRE_RANGE_MAX.lessThan(ThreadLocalHandles.MIN_VALUE) || ENTIRE_RANGE_MIN.greaterThan(Integer.MAX_VALUE));
        assert (ENTIRE_RANGE_MAX.lessThan(JNIGlobalHandles.MIN_VALUE) || ENTIRE_RANGE_MIN.greaterThan(JNIGlobalHandles.MAX_VALUE));
    }
}

