/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.heap.ImageHeap;
import com.oracle.graal.pointsto.heap.ImageHeapObject;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.heap.value.ValueSupplier;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class SVMImageHeapScanner
extends ImageHeapScanner {
    private final ImageClassLoader loader;
    protected HostedMetaAccess hostedMetaAccess;
    private final Class<?> economicMapImpl;
    private final Field economicMapImplEntriesField;
    private final Field economicMapImplHashArrayField;
    private final RuntimeReflectionSupport reflectionSupport;

    public SVMImageHeapScanner(ImageHeap imageHeap, ImageClassLoader loader, AnalysisMetaAccess metaAccess, SnippetReflectionProvider snippetReflection, ConstantReflectionProvider aConstantReflection, ObjectScanningObserver aScanningObserver) {
        super(imageHeap, metaAccess, snippetReflection, aConstantReflection, aScanningObserver);
        this.loader = loader;
        this.economicMapImpl = this.getClass("org.graalvm.collections.EconomicMapImpl");
        this.economicMapImplEntriesField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"entries");
        this.economicMapImplHashArrayField = ReflectionUtil.lookupField(this.economicMapImpl, (String)"hashArray");
        ImageSingletons.add(ImageHeapScanner.class, (Object)((Object)this));
        this.reflectionSupport = (RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class);
    }

    public static ImageHeapScanner instance() {
        return (ImageHeapScanner)ImageSingletons.lookup(ImageHeapScanner.class);
    }

    public void setHostedMetaAccess(HostedMetaAccess hostedMetaAccess) {
        this.hostedMetaAccess = hostedMetaAccess;
    }

    protected Class<?> getClass(String className) {
        return this.loader.findClassOrFail(className);
    }

    protected ImageHeapObject getOrCreateConstantReachableTask(JavaConstant javaConstant, ObjectScanner.ScanReason reason, Consumer<ObjectScanner.ScanReason> onAnalysisModified) {
        VMError.guarantee(javaConstant instanceof SubstrateObjectConstant, "Not a substrate constant " + javaConstant);
        return super.getOrCreateConstantReachableTask(javaConstant, reason, onAnalysisModified);
    }

    protected Object unwrapObject(JavaConstant constant) {
        return SubstrateObjectConstant.asObject(Object.class, constant);
    }

    public boolean isValueAvailable(AnalysisField field) {
        if (field.wrapped instanceof ReadableJavaField) {
            ReadableJavaField readableField = (ReadableJavaField)field.wrapped;
            return readableField.isValueAvailable();
        }
        return super.isValueAvailable(field);
    }

    protected ValueSupplier<JavaConstant> readHostedFieldValue(AnalysisField field, JavaConstant receiver) {
        AnalysisConstantReflectionProvider aConstantReflection = (AnalysisConstantReflectionProvider)this.constantReflection;
        return aConstantReflection.readHostedFieldValue(field, this.hostedMetaAccess, receiver);
    }

    protected JavaConstant transformFieldValue(AnalysisField field, JavaConstant receiverConstant, JavaConstant originalValueConstant) {
        return ((AnalysisConstantReflectionProvider)this.constantReflection).interceptValue(field, originalValueConstant);
    }

    protected boolean skipScanning() {
        return BuildPhaseProvider.isAnalysisFinished();
    }

    protected void rescanEconomicMap(EconomicMap<?, ?> map) {
        super.rescanEconomicMap(map);
        if (map.getClass() == this.economicMapImpl) {
            this.rescanField(map, this.economicMapImplEntriesField);
            this.rescanField(map, this.economicMapImplHashArrayField);
        }
    }

    protected void onObjectReachable(ImageHeapObject imageHeapObject) {
        super.onObjectReachable(imageHeapObject);
        Object object = SubstrateObjectConstant.asObject((Constant)imageHeapObject.getObject());
        if (object instanceof Field || object instanceof Executable) {
            this.reflectionSupport.registerHeapReflectionObject((AccessibleObject)object);
        } else if (object instanceof DynamicHub) {
            this.reflectionSupport.registerHeapDynamicHub(object);
        }
    }
}

