/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.diagnostic;

import com.oracle.svm.core.util.VMError;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;

public final class HostedHeapDump {
    private static HotSpotDiagnosticMXBean diagnosticBean;

    private HostedHeapDump() {
    }

    private static HotSpotDiagnosticMXBean getDiagnosticBean() {
        if (diagnosticBean == null) {
            try {
                diagnosticBean = ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Cannot create diagnostic bean.", e);
            }
        }
        return diagnosticBean;
    }

    public static void take(String outputFile) {
        HotSpotDiagnosticMXBean bean = HostedHeapDump.getDiagnosticBean();
        try {
            bean.dumpHeap(outputFile, true);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Cannot dump heap.", e);
        }
    }
}

