/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.impl.CConstantValueSupport;

public final class CConstantValueSupportImpl
implements CConstantValueSupport {
    private final NativeLibraries nativeLibraries;
    private final MetaAccessProvider metaAccess;

    public CConstantValueSupportImpl(NativeLibraries nativeLibraries, MetaAccessProvider metaAccess) {
        this.nativeLibraries = nativeLibraries;
        this.metaAccess = metaAccess;
    }

    public <T> T getCConstantValue(Class<?> declaringClass, String methodName, Class<T> returnType) {
        ResolvedJavaMethod method;
        try {
            method = this.metaAccess.lookupJavaMethod((Executable)declaringClass.getMethod(methodName, new Class[0]));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw VMError.shouldNotReachHere("Method not found: " + declaringClass.getName() + "." + methodName);
        }
        if (method.getAnnotation(CConstant.class) == null) {
            throw VMError.shouldNotReachHere("Method " + declaringClass.getName() + "." + methodName + " is not annotated with @" + CConstant.class.getSimpleName());
        }
        ConstantInfo constantInfo = (ConstantInfo)this.nativeLibraries.findElementInfo((AnnotatedElement)method);
        Object value = constantInfo.getValueInfo().getProperty();
        switch (constantInfo.getKind()) {
            case INTEGER: 
            case POINTER: {
                Long longValue = (Long)value;
                if (returnType == Boolean.class) {
                    return returnType.cast(longValue != 0L);
                }
                if (returnType == Integer.class) {
                    return returnType.cast((int)longValue.longValue());
                }
                if (returnType != Long.class) break;
                return returnType.cast(value);
            }
            case FLOAT: {
                if (returnType != Double.class) break;
                return returnType.cast(value);
            }
            case STRING: {
                if (returnType != String.class) break;
                return returnType.cast(value);
            }
            case BYTEARRAY: {
                if (returnType != byte[].class) break;
                return returnType.cast(value);
            }
        }
        throw VMError.shouldNotReachHere("Unexpected returnType: " + returnType.getName());
    }
}

