/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.WordBase;

public abstract class CustomTypeFieldHandler {
    protected final BigBang bb;
    private final AnalysisMetaAccess metaAccess;
    private Set<AnalysisField> processedFields = ConcurrentHashMap.newKeySet();

    public CustomTypeFieldHandler(BigBang bb, AnalysisMetaAccess metaAccess) {
        this.bb = bb;
        this.metaAccess = metaAccess;
    }

    public void handleField(AnalysisField field) {
        if (this.processedFields.contains(field)) {
            return;
        }
        assert (field.isAccessed());
        if (field.wrapped instanceof ComputedValueField) {
            ComputedValueField computedField = (ComputedValueField)field.wrapped;
            Class<?>[] customTypes = computedField.getCustomTypes();
            if (customTypes != null) {
                this.injectFieldTypes(field, this.transformTypes(field, customTypes));
                field.setCanBeNull(computedField.getComputedValueCanBeNull());
            }
        } else {
            UnknownObjectField unknownObjectField = (UnknownObjectField)field.getAnnotation(UnknownObjectField.class);
            UnknownPrimitiveField unknownPrimitiveField = (UnknownPrimitiveField)field.getAnnotation(UnknownPrimitiveField.class);
            if (unknownObjectField != null) {
                assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownObjectField annotated field " + field.format("%H.%n") + " cannot be final";
                assert (field.getJavaKind() == JavaKind.Object);
                field.setCanBeNull(unknownObjectField.canBeNull());
                this.injectFieldTypes(field, this.extractAnnotationTypes(field, unknownObjectField));
            } else if (unknownPrimitiveField != null) {
                assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownPrimitiveField annotated field " + field.format("%H.%n") + " cannot be final";
                field.registerAsWritten(null);
            }
        }
        this.processedFields.add(field);
    }

    private List<AnalysisType> extractAnnotationTypes(AnalysisField field, UnknownObjectField unknownObjectField) {
        ArrayList annotationTypes = new ArrayList(Arrays.asList(unknownObjectField.types()));
        for (String annotationTypeName : unknownObjectField.fullyQualifiedTypes()) {
            try {
                Class<?> annotationType = Class.forName(annotationTypeName);
                annotationTypes.add(annotationType);
            }
            catch (ClassNotFoundException e) {
                throw JVMCIError.shouldNotReachHere((String)("Annotation type not found " + annotationTypeName));
            }
        }
        return this.transformTypes(field, annotationTypes.toArray(new Class[0]));
    }

    private void injectFieldTypes(AnalysisField field, List<AnalysisType> customTypes) {
        for (AnalysisType type : customTypes) {
            if (type.isPrimitive()) continue;
            type.registerAsAllocated(null);
        }
        this.injectFieldTypes(field, customTypes.toArray(new AnalysisType[0]));
    }

    protected abstract void injectFieldTypes(AnalysisField var1, AnalysisType ... var2);

    private List<AnalysisType> transformTypes(AnalysisField field, Class<?>[] types) {
        ArrayList<AnalysisType> customTypes = new ArrayList<AnalysisType>();
        AnalysisType declaredType = field.getType();
        for (Class<?> customType : types) {
            AnalysisType aCustomType = this.metaAccess.lookupJavaType(customType);
            assert (!WordBase.class.isAssignableFrom(customType)) : "Custom type must not be a subtype of WordBase: field: " + field + " | declared type: " + declaredType + " | custom type: " + customType;
            assert (declaredType.isAssignableFrom((ResolvedJavaType)aCustomType)) : "Custom type must be a subtype of the declared type: field: " + field + " | declared type: " + declaredType + " | custom type: " + customType;
            assert (aCustomType.isPrimitive() || aCustomType.isArray() || aCustomType.isInstanceClass() && !Modifier.isAbstract(aCustomType.getModifiers())) : "Custom type cannot be abstract: field: " + field + " | custom type " + aCustomType;
            customTypes.add(aCustomType);
        }
        return customTypes;
    }

    public void cleanupAfterAnalysis() {
        this.processedFields = null;
    }
}

