/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.hub.AnnotationsEncoding;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class AnnotationsProcessor {
    public static Object encodeAnnotations(AnalysisMetaAccess metaAccess, Annotation[] allAnnotations, Annotation[] declaredAnnotations, Object oldEncoding) {
        Object newEncoding;
        if (allAnnotations.length == 0 && declaredAnnotations.length == 0) {
            newEncoding = null;
        } else {
            HashSet all = new HashSet();
            Collections.addAll(all, allAnnotations);
            Collections.addAll(all, declaredAnnotations);
            Set<Annotation> usedAnnotations = all.stream().filter(a -> {
                try {
                    AnalysisType annotationClass = metaAccess.lookupJavaType(a.getClass());
                    return AnnotationsProcessor.isAnnotationUsed(annotationClass);
                }
                catch (AnalysisError.TypeNotFoundError e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            Set<Annotation> usedDeclared = AnnotationsProcessor.filterUsedAnnotation(usedAnnotations, declaredAnnotations);
            Object object = newEncoding = usedAnnotations.size() == 0 ? null : AnnotationsEncoding.encodeAnnotations(usedAnnotations, usedDeclared);
        }
        if (oldEncoding != null && oldEncoding.equals(newEncoding)) {
            return oldEncoding;
        }
        return newEncoding;
    }

    private static boolean isAnnotationUsed(AnalysisType annotationType) {
        if (annotationType.isReachable()) {
            return true;
        }
        assert (annotationType.getInterfaces().length == 1) : annotationType;
        AnalysisType annotationInterfaceType = annotationType.getInterfaces()[0];
        return annotationInterfaceType.isReachable();
    }

    private static Set<Annotation> filterUsedAnnotation(Set<Annotation> used, Annotation[] rest) {
        if (rest == null) {
            return null;
        }
        HashSet<Annotation> restUsed = new HashSet<Annotation>();
        for (Annotation a : rest) {
            if (!used.contains(a)) continue;
            restUsed.add(a);
        }
        return restUsed;
    }
}

