/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.handles.ThreadLocalHandles;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.CompilerHandle;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;

public final class IsolatedCompileContext {
    private static final FastThreadLocalObject<IsolatedCompileContext> currentContext = FastThreadLocalFactory.createObject(IsolatedCompileContext.class, "IsolatedCompileContext.currentContext");
    private final ClientIsolateThread client;
    private final ThreadLocalHandles<ObjectHandle> handles = new ThreadLocalHandles(64);

    public static IsolatedCompileContext get() {
        return currentContext.get();
    }

    public static void set(IsolatedCompileContext context) {
        assert (context == null != (currentContext.get() == null));
        currentContext.set(context);
    }

    public IsolatedCompileContext(ClientIsolateThread clientIsolate) {
        this.client = clientIsolate;
    }

    public ClientIsolateThread getClient() {
        return this.client;
    }

    public <T> CompilerHandle<T> hand(T object) {
        return (CompilerHandle)this.handles.create(object);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <T> T unhand(CompilerHandle<? extends T> handle) {
        return (T)this.handles.getObject(handle);
    }

    public ClientHandle<String> createStringInClient(CharSequence s) {
        try (CTypeConversion.CCharPointerHolder cstr = CTypeConversion.toCString((CharSequence)s);){
            ClientHandle<String> clientHandle = IsolatedCompileContext.createStringInClient0(this.client, cstr.get());
            return clientHandle;
        }
    }

    public ClientHandle<String[]> createStringArrayInClient(String[] array) {
        try (CTypeConversion.CCharPointerPointerHolder cstrs = CTypeConversion.toCStrings((CharSequence[])array);){
            ClientHandle<String[]> clientHandle = IsolatedCompileContext.createStringArrayInClient0(this.client, array.length, cstrs.get());
            return clientHandle;
        }
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<String> createStringInClient0(ClientIsolateThread client, CCharPointer cstr) {
        return IsolatedCompileClient.get().hand(CTypeConversion.toJavaString((CCharPointer)cstr));
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(publishAs=CEntryPointOptions.Publish.NotPublished)
    private static ClientHandle<String[]> createStringArrayInClient0(ClientIsolateThread client, int length, CCharPointerPointer ptrs) {
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = CTypeConversion.toJavaString((CCharPointer)ptrs.read(i));
        }
        return IsolatedCompileClient.get().hand(array);
    }
}

