/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.TimeUtils;

@TargetClass(className="jdk.internal.misc.Unsafe")
final class Target_jdk_internal_misc_Unsafe_JavaThreads {
    Target_jdk_internal_misc_Unsafe_JavaThreads() {
    }

    @Substitute
    void park(boolean isAbsolute, long time) {
        if (!isAbsolute && time == 0L) {
            PlatformThreads.parkCurrentPlatformOrCarrierThread();
        } else {
            long delayNanos = TimeUtils.delayNanos(isAbsolute, time);
            PlatformThreads.parkCurrentPlatformOrCarrierThread(delayNanos);
        }
    }

    @Substitute
    void unpark(Object threadObj) {
        if (threadObj != null) {
            if (!(threadObj instanceof Thread)) {
                throw new IllegalArgumentException("Unsafe.unpark(!(thread instanceof Thread))");
            }
            Thread thread = (Thread)threadObj;
            if (!VirtualThreads.isSupported() || !VirtualThreads.singleton().isVirtual(thread)) {
                PlatformThreads.unpark(thread);
            }
        }
    }
}

