/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationImpl;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.thread.Continuation;
import com.oracle.svm.core.thread.LoomSupport;
import com.oracle.svm.core.thread.LoomVirtualThreads;
import com.oracle.svm.core.thread.SubstrateVirtualThreads;
import com.oracle.svm.core.thread.VirtualThreads;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.util.concurrent.ForkJoinPool;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Platforms(value={Platform.HOSTED_ONLY.class})
public class ContinuationsFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (Continuation.isSupported()) {
            VirtualThreads impl;
            if (LoomSupport.isEnabled()) {
                impl = new LoomVirtualThreads();
            } else {
                UserError.guarantee(JavaVersionUtil.JAVA_SPEC >= 17, "Continuations (%s) are currently supported only on JDK 17 and later.", SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"));
                impl = new SubstrateVirtualThreads();
            }
            ImageSingletons.add(VirtualThreads.class, (Object)impl);
        } else {
            UserError.guarantee(SubstrateOptions.UseLoom.getValue() == false, "%s cannot be enabled without option %s.", SubstrateOptionsParser.commandArgument(SubstrateOptions.UseLoom, "+"), SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"));
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Continuation.isSupported()) {
            access.registerAsInHeap(StoredContinuation.class);
            VMError.guarantee(ConfigurationValues.getObjectLayout().getFirstFieldOffset() == 8, "Unexpected monitor field offset. Continuation support currently needs option " + SubstrateOptionsParser.commandArgument(SubstrateOptions.SpawnIsolates, "+") + " and compressed 32-bit reference support.");
            if (LoomSupport.isEnabled()) {
                RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ForkJoinPool.class, (String)"compensatedBlock", (Class[])new Class[]{ForkJoinPool.ManagedBlocker.class})});
            }
        } else {
            access.registerReachabilityHandler(a -> ContinuationsFeature.abortIfUnsupported(), new Object[]{StoredContinuationImpl.class});
        }
    }

    static void abortIfUnsupported() {
        if (!Continuation.isSupported()) {
            throw UserError.abort("Continuation support is used, but not enabled. Use options %s or %s.", SubstrateOptionsParser.commandArgument(SubstrateOptions.SupportContinuations, "+"), SubstrateOptionsParser.commandArgument(SubstrateOptions.UseLoom, "+"));
        }
    }
}

