/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.StubCallingConvention;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.StoredContinuationImpl;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class Continuation {
    public static final int YIELDING = -2;
    public static final int YIELD_SUCCESS = 0;
    private final Runnable target;
    public StoredContinuation stored;
    private Pointer sp;
    private CodePointer ip;
    private Pointer bottomSP;
    private boolean done;
    private int overflowCheckState;

    @Fold
    public static boolean isSupported() {
        return SubstrateOptions.SupportContinuations.getValue();
    }

    Continuation(Runnable target) {
        this.target = target;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public CodePointer getIP() {
        return this.ip;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setIP(CodePointer ip) {
        this.ip = ip;
    }

    public Pointer getBottomSP() {
        return this.bottomSP;
    }

    void enter() {
        int stateBefore = StackOverflowCheck.singleton().getState();
        VMError.guarantee(!StackOverflowCheck.singleton().isYellowZoneAvailable());
        boolean isContinue = this.ip.isNonNull();
        if (isContinue) {
            StackOverflowCheck.singleton().setState(this.overflowCheckState);
        }
        try {
            Continuation.enter0(this, isContinue);
        }
        catch (StackOverflowError e) {
            throw e == ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR ? new StackOverflowError() : e;
        }
        finally {
            this.overflowCheckState = StackOverflowCheck.singleton().getState();
            StackOverflowCheck.singleton().setState(stateBefore);
            assert (this.sp.isNull() && this.bottomSP.isNull());
        }
    }

    @StubCallingConvention
    @NeverInline(value="Keep the frame with the saved registers.")
    private static void enter0(Continuation self, boolean isContinue) {
        self.enter1(isContinue);
    }

    @NeverInline(value="Accesses caller stack pointer and return address.")
    @Uninterruptible(reason="Copies stack frames containing references.")
    private Object enter1(boolean isContinue) {
        Pointer callerSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer callerIP = KnownIntrinsics.readReturnAddress();
        Pointer currentSP = KnownIntrinsics.readStackPointer();
        assert (this.sp.isNull() && this.bottomSP.isNull());
        if (isContinue) {
            assert (this.stored != null && this.ip.isNonNull());
            int totalSize = StoredContinuationImpl.readAllFrameSize(this.stored);
            Pointer topSP = currentSP.subtract(totalSize);
            if (!StackOverflowCheck.singleton().isWithinBounds((UnsignedWord)topSP)) {
                throw ImplicitExceptions.CACHED_STACK_OVERFLOW_ERROR;
            }
            Pointer frameData = StoredContinuationImpl.payloadFrameStart(this.stored);
            int offset = 0;
            for (int next = offset + 32; next < totalSize; next += 32) {
                Pointer src = frameData.add(offset);
                Pointer dst = topSP.add(offset);
                long l0 = src.readLong(0);
                long l8 = src.readLong(8);
                long l16 = src.readLong(16);
                long l24 = src.readLong(24);
                dst.writeLong(0, l0);
                dst.writeLong(8, l8);
                dst.writeLong(16, l16);
                dst.writeLong(24, l24);
                offset = next;
            }
            while (offset < totalSize) {
                topSP.writeByte(offset, frameData.readByte(offset));
                ++offset;
            }
            CodePointer storedIP = this.ip;
            this.stored = null;
            this.ip = callerIP;
            this.sp = callerSP;
            this.bottomSP = currentSP;
            KnownIntrinsics.farReturn(0, topSP, storedIP, false);
            throw VMError.shouldNotReachHere();
        }
        assert (this.ip.isNull() && this.stored == null);
        this.ip = callerIP;
        this.sp = callerSP;
        this.bottomSP = currentSP;
        this.enter2();
        return null;
    }

    @Uninterruptible(reason="Not actually, but because caller is uninterruptible.", calleeMustBe=false)
    private void enter2() {
        try {
            this.target.run();
        }
        finally {
            this.finish();
        }
    }

    int tryPreempt(Thread thread) {
        TryPreemptThunk thunk = new TryPreemptThunk(this, thread);
        JavaVMOperation.enqueueBlockingSafepoint("tryForceYield0", thunk);
        return thunk.preemptStatus;
    }

    int yield() {
        return Continuation.yield0(this);
    }

    @StubCallingConvention
    @NeverInline(value="Keep the frame with the saved registers.")
    private static Integer yield0(Continuation self) {
        return self.yield1();
    }

    @NeverInline(value="access stack pointer")
    private Integer yield1() {
        Pointer leafSP = KnownIntrinsics.readCallerStackPointer();
        CodePointer leafIP = KnownIntrinsics.readReturnAddress();
        Pointer returnSP = this.sp;
        CodePointer returnIP = this.ip;
        int preemptStatus = StoredContinuationImpl.allocateFromCurrentStack(this, this.bottomSP, leafSP, leafIP);
        if (preemptStatus != 0) {
            return preemptStatus;
        }
        this.ip = leafIP;
        this.sp = (Pointer)WordFactory.nullPointer();
        this.bottomSP = (Pointer)WordFactory.nullPointer();
        KnownIntrinsics.farReturn(0, returnSP, returnIP, false);
        throw VMError.shouldNotReachHere();
    }

    public boolean isStarted() {
        return this.ip.isNonNull();
    }

    public boolean isEmpty() {
        return this.ip.isNull();
    }

    public boolean isDone() {
        return this.done;
    }

    public void finish() {
        this.done = true;
        this.ip = (CodePointer)WordFactory.nullPointer();
        this.sp = (Pointer)WordFactory.nullPointer();
        this.bottomSP = (Pointer)WordFactory.nullPointer();
        assert (this.isEmpty());
    }

    static class TryPreemptThunk
    implements SubstrateUtil.Thunk {
        int preemptStatus = 0;
        final Continuation cont;
        final Thread thread;

        TryPreemptThunk(Continuation cont, Thread thread) {
            this.cont = cont;
            this.thread = thread;
        }

        @Override
        public void invoke() {
            IsolateThread vmThread = PlatformThreads.getIsolateThread(this.thread);
            Pointer bottomSP = this.cont.bottomSP;
            Pointer returnSP = this.cont.sp;
            CodePointer returnIP = this.cont.ip;
            this.preemptStatus = StoredContinuationImpl.allocateFromForeignStack(this.cont, bottomSP, vmThread);
            if (this.preemptStatus == 0) {
                this.cont.sp = (Pointer)WordFactory.nullPointer();
                this.cont.bottomSP = (Pointer)WordFactory.nullPointer();
                VMThreads.ActionOnExitSafepointSupport.setSwitchStack(vmThread);
                VMThreads.ActionOnExitSafepointSupport.setSwitchStackTarget(vmThread, returnSP, returnIP);
            }
        }
    }
}

