/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.Sched;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.posix.headers.linux.LinuxPthread;
import com.oracle.svm.core.posix.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class PosixPlatformThreads
extends PlatformThreads {
    private static final CEntryPointLiteral<CFunctionPointer> pthreadStartRoutine = CEntryPointLiteral.create(PosixPlatformThreads.class, (String)"pthreadStartRoutine", (Class[])new Class[]{PlatformThreads.ThreadStartData.class});

    @SuppressFBWarnings(value={"BC"}, justification="Cast for @TargetClass")
    private static Target_java_lang_Thread toTarget(Thread thread) {
        return (Target_java_lang_Thread)Target_java_lang_Thread.class.cast(thread);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PosixPlatformThreads() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doStartThread(Thread thread, long stackSize) {
        Pthread.pthread_attr_t attributes = (Pthread.pthread_attr_t)StackValue.get(Pthread.pthread_attr_t.class);
        if (Pthread.pthread_attr_init(attributes) != 0) {
            return false;
        }
        try {
            if (Pthread.pthread_attr_setdetachstate(attributes, Pthread.PTHREAD_CREATE_JOINABLE()) != 0) {
                boolean bl = false;
                return bl;
            }
            UnsignedWord threadStackSize = WordFactory.unsigned((long)stackSize);
            if (threadStackSize.notEqual((UnsignedWord)WordFactory.zero())) {
                threadStackSize = UnsignedUtils.max(threadStackSize, Pthread.PTHREAD_STACK_MIN());
                if (Pthread.pthread_attr_setstacksize(attributes, threadStackSize = UnsignedUtils.roundUp(threadStackSize, WordFactory.unsigned((int)Unistd.getpagesize()))) != 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            Object startData = this.prepareStart(thread, SizeOf.get(PlatformThreads.ThreadStartData.class));
            Pthread.pthread_tPointer newThread = (Pthread.pthread_tPointer)StackValue.get(Pthread.pthread_tPointer.class);
            if (Pthread.pthread_create(newThread, attributes, (WordBase)pthreadStartRoutine.getFunctionPointer(), startData) != 0) {
                this.undoPrepareStartOnError(thread, (PlatformThreads.ThreadStartData)startData);
                boolean bl = false;
                return bl;
            }
            PosixPlatformThreads.setPthreadIdentifier(thread, newThread.read());
            boolean bl = true;
            return bl;
        }
        finally {
            Pthread.pthread_attr_destroy(attributes);
        }
    }

    private static void setPthreadIdentifier(Thread thread, Pthread.pthread_t pthread) {
        PosixPlatformThreads.toTarget((Thread)thread).hasPthreadIdentifier = true;
        PosixPlatformThreads.toTarget((Thread)thread).pthreadIdentifier = pthread;
    }

    static Pthread.pthread_t getPthreadIdentifier(Thread thread) {
        return PosixPlatformThreads.toTarget((Thread)thread).pthreadIdentifier;
    }

    static boolean hasThreadIdentifier(Thread thread) {
        return PosixPlatformThreads.toTarget((Thread)thread).hasPthreadIdentifier;
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
        if (!PosixPlatformThreads.hasThreadIdentifier(thread)) {
            return;
        }
        if (IsDefined.isDarwin() && thread != Thread.currentThread()) {
            return;
        }
        int startIndex = Math.max(0, name.length() - 15);
        String pthreadName = name.substring(startIndex);
        assert (pthreadName.length() < 16) : "thread name for pthread has a maximum length of 16 characters including the terminating 0";
        try (CTypeConversion.CCharPointerHolder threadNameHolder = CTypeConversion.toCString((CharSequence)pthreadName);){
            if (IsDefined.isLinux()) {
                LinuxPthread.pthread_setname_np(PosixPlatformThreads.getPthreadIdentifier(thread), threadNameHolder.get());
            } else if (IsDefined.isDarwin()) {
                assert (thread == Thread.currentThread()) : "Darwin only allows setting the name of the current thread";
                DarwinPthread.pthread_setname_np(threadNameHolder.get());
            } else {
                VMError.unsupportedFeature("PosixPlatformThreads.setNativeName on unknown OS");
            }
        }
    }

    @Override
    protected void yieldCurrent() {
        Sched.sched_yield();
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(prologue=PthreadStartRoutinePrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    static WordBase pthreadStartRoutine(PlatformThreads.ThreadStartData data) {
        ObjectHandle threadHandle = data.getThreadHandle();
        PosixPlatformThreads.freeStartData(data);
        PosixPlatformThreads.threadStartRoutine(threadHandle);
        return WordFactory.nullPointer();
    }

    @Override
    protected void beforeThreadRun(Thread thread) {
        PosixPlatformThreads.setPthreadIdentifier(thread, Pthread.pthread_self());
        this.setNativeName(thread, thread.getName());
    }

    private static class PthreadStartRoutinePrologue
    implements CEntryPointOptions.Prologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to attach a newly launched thread.");

        private PthreadStartRoutinePrologue() {
        }

        @Uninterruptible(reason="prologue")
        static void enter(PlatformThreads.ThreadStartData data) {
            int code = CEntryPointActions.enterAttachThread(data.getIsolate(), true, false);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }
}

