/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.AbstractUninterruptibleHashtable;
import com.oracle.svm.core.jdk.UninterruptibleEntry;
import com.oracle.svm.core.jfr.JfrBuffer;
import com.oracle.svm.core.jfr.JfrBufferAccess;
import com.oracle.svm.core.jfr.JfrBufferType;
import com.oracle.svm.core.jfr.JfrChunkWriter;
import com.oracle.svm.core.jfr.JfrConstantPool;
import com.oracle.svm.core.jfr.JfrNativeEventWriter;
import com.oracle.svm.core.jfr.JfrNativeEventWriterData;
import com.oracle.svm.core.jfr.JfrNativeEventWriterDataAccess;
import com.oracle.svm.core.jfr.JfrType;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.traceid.JfrTraceIdEpoch;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.thread.JavaLangThreadGroupSubstitutions;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import jdk.jfr.internal.Options;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.WordFactory;

public final class JfrThreadRepository
implements JfrConstantPool {
    private static final long INITIAL_BUFFER_SIZE = Options.getThreadBufferSize();
    private final VMMutex mutex;
    private final JfrThreadEpochData epochData0 = new JfrThreadEpochData();
    private final JfrThreadEpochData epochData1 = new JfrThreadEpochData();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    JfrThreadRepository() {
        this.mutex = new VMMutex("jfrThreadRepository");
    }

    @Uninterruptible(reason="Prevent any JFR events from triggering.")
    public void registerRunningThreads() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.mutex.lockNoTransition();
        try {
            IsolateThread isolateThread = VMThreads.firstThread();
            while (isolateThread.isNonNull()) {
                Thread thread = PlatformThreads.fromVMThread(isolateThread);
                if (thread != null) {
                    this.registerThread0(thread);
                }
                isolateThread = VMThreads.nextThread(isolateThread);
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    public void registerThread(Thread thread) {
        if (!SubstrateJVM.isRecording()) {
            return;
        }
        this.mutex.lockNoTransition();
        try {
            this.registerThread0(thread);
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private void registerThread0(Thread thread) {
        assert (SubstrateJVM.isRecording());
        JfrThreadEpochData epochData = this.getEpochData(false);
        if (epochData.threadBuffer.isNull()) {
            epochData.threadBuffer = JfrBufferAccess.allocate(WordFactory.unsigned((long)INITIAL_BUFFER_SIZE), JfrBufferType.C_HEAP);
        }
        JfrVisited visitedThread = (JfrVisited)StackValue.get(JfrVisited.class);
        visitedThread.setId(thread.getId());
        visitedThread.setHash((int)thread.getId());
        if (!epochData.visitedThreads.putIfAbsent(visitedThread)) {
            return;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, epochData.threadBuffer);
        JfrNativeEventWriter.putLong(data, thread.getId());
        JfrNativeEventWriter.putString(data, thread.getName());
        JfrNativeEventWriter.putLong(data, thread.getId());
        JfrNativeEventWriter.putString(data, thread.getName());
        JfrNativeEventWriter.putLong(data, thread.getId());
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            long threadGroupId = JavaLangThreadGroupSubstitutions.getThreadGroupId(threadGroup);
            JfrNativeEventWriter.putLong(data, threadGroupId);
            this.registerThreadGroup(threadGroupId, threadGroup);
        } else {
            JfrNativeEventWriter.putLong(data, 0L);
        }
        JfrNativeEventWriter.commit(data);
        epochData.threadBuffer = data.getJfrBuffer();
    }

    @Uninterruptible(reason="Epoch must not change while in this method.")
    private void registerThreadGroup(long threadGroupId, ThreadGroup threadGroup) {
        VMError.guarantee(this.mutex.isOwner(), "The current thread is not the owner of the mutex!");
        JfrThreadEpochData epochData = this.getEpochData(false);
        if (epochData.threadGroupBuffer.isNull()) {
            epochData.threadGroupBuffer = JfrBufferAccess.allocate(WordFactory.unsigned((long)INITIAL_BUFFER_SIZE), JfrBufferType.C_HEAP);
        }
        JfrVisited jfrVisited = (JfrVisited)StackValue.get(JfrVisited.class);
        jfrVisited.setId(threadGroupId);
        jfrVisited.setHash((int)threadGroupId);
        if (!epochData.visitedThreadGroups.putIfAbsent(jfrVisited)) {
            return;
        }
        JfrNativeEventWriterData data = (JfrNativeEventWriterData)StackValue.get(JfrNativeEventWriterData.class);
        JfrNativeEventWriterDataAccess.initialize(data, epochData.threadGroupBuffer);
        JfrNativeEventWriter.putLong(data, threadGroupId);
        ThreadGroup parentThreadGroup = JavaLangThreadGroupSubstitutions.getParentThreadGroupUnsafe(threadGroup);
        long parentThreadGroupId = 0L;
        if (parentThreadGroup != null) {
            parentThreadGroupId = JavaLangThreadGroupSubstitutions.getThreadGroupId(parentThreadGroup);
        }
        JfrNativeEventWriter.putLong(data, parentThreadGroupId);
        JfrNativeEventWriter.putString(data, threadGroup.getName());
        JfrNativeEventWriter.commit(data);
        epochData.threadGroupBuffer = data.getJfrBuffer();
        if (parentThreadGroupId > 0L) {
            this.registerThreadGroup(parentThreadGroupId, parentThreadGroup);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private JfrThreadEpochData getEpochData(boolean previousEpoch) {
        boolean epoch = previousEpoch ? JfrTraceIdEpoch.getInstance().previousEpoch() : JfrTraceIdEpoch.getInstance().currentEpoch();
        return epoch ? this.epochData0 : this.epochData1;
    }

    @Override
    public int write(JfrChunkWriter writer) {
        JfrThreadEpochData epochData = this.getEpochData(true);
        int count = JfrThreadRepository.writeThreads(writer, epochData);
        epochData.clear();
        return count += JfrThreadRepository.writeThreadGroups(writer, epochData);
    }

    private static int writeThreads(JfrChunkWriter writer, JfrThreadEpochData epochData) {
        VMError.guarantee(epochData.visitedThreads.getSize() > 0, "Thread repository must not be empty.");
        writer.writeCompressedLong(JfrType.Thread.getId());
        writer.writeCompressedInt(epochData.visitedThreads.getSize());
        writer.write(epochData.threadBuffer);
        return 1;
    }

    private static int writeThreadGroups(JfrChunkWriter writer, JfrThreadEpochData epochData) {
        int threadGroupCount = epochData.visitedThreadGroups.getSize();
        if (threadGroupCount == 0) {
            return 0;
        }
        writer.writeCompressedLong(JfrType.ThreadGroup.getId());
        writer.writeCompressedInt(threadGroupCount);
        writer.write(epochData.threadGroupBuffer);
        return 1;
    }

    @Uninterruptible(reason="Releasing repository buffers.")
    public void teardown() {
        this.epochData0.teardown();
        this.epochData1.teardown();
    }

    private static class JfrThreadEpochData {
        private final JfrVisitedTable visitedThreads = new JfrVisitedTable();
        private final JfrVisitedTable visitedThreadGroups = new JfrVisitedTable();
        private JfrBuffer threadBuffer;
        private JfrBuffer threadGroupBuffer;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        JfrThreadEpochData() {
        }

        public void clear() {
            this.visitedThreads.clear();
            this.visitedThreadGroups.clear();
            JfrBufferAccess.reinitialize(this.threadBuffer);
            JfrBufferAccess.reinitialize(this.threadGroupBuffer);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void teardown() {
            this.visitedThreads.teardown();
            this.visitedThreadGroups.teardown();
            JfrBufferAccess.free(this.threadBuffer);
            this.threadBuffer = (JfrBuffer)WordFactory.nullPointer();
            JfrBufferAccess.free(this.threadGroupBuffer);
            this.threadGroupBuffer = (JfrBuffer)WordFactory.nullPointer();
        }
    }

    private static class JfrVisitedTable
    extends AbstractUninterruptibleHashtable {
        private JfrVisitedTable() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected JfrVisited[] createTable(int size) {
            return new JfrVisited[size];
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public JfrVisited[] getTable() {
            return (JfrVisited[])super.getTable();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isEqual(UninterruptibleEntry v0, UninterruptibleEntry v1) {
            JfrVisited a = (JfrVisited)v0;
            JfrVisited b = (JfrVisited)v1;
            return a.getId() == b.getId();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected UninterruptibleEntry copyToHeap(UninterruptibleEntry visitedOnStack) {
            return this.copyToHeap(visitedOnStack, SizeOf.unsigned(JfrVisited.class));
        }
    }

    @RawStructure
    static interface JfrVisited
    extends UninterruptibleEntry {
        @RawField
        public long getId();

        @RawField
        public void setId(long var1);
    }
}

