/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.resources.ResourceStorageEntry;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class ResourceURLConnection
extends URLConnection {
    private byte[] data;

    public ResourceURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() {
        if (this.connected) {
            return;
        }
        this.connected = true;
        String urlHost = this.url.getHost();
        String hostNameOrNull = urlHost != null && !urlHost.isEmpty() ? urlHost : null;
        String urlPath = this.url.getPath();
        if (urlPath.isEmpty()) {
            throw new IllegalArgumentException("Empty URL path not allowed in resource URL");
        }
        String resourceName = urlPath.substring(1);
        ResourceStorageEntry entry = Resources.get(hostNameOrNull, resourceName);
        if (entry != null) {
            List<byte[]> bytes = entry.getData();
            String urlRef = this.url.getRef();
            int index = 0;
            if (urlRef != null) {
                try {
                    index = Integer.valueOf(urlRef);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("URL anchor '#" + urlRef + "' not allowed in resource URL");
                }
            }
            this.data = index < bytes.size() ? bytes.get(index) : bytes.get(0);
        } else {
            this.data = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.data == null) {
            throw new FileNotFoundException(this.url.toString());
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public long getContentLengthLong() {
        this.connect();
        return this.data != null ? (long)this.data.length : -1L;
    }
}

