/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ByteArrayChannel
implements SeekableByteChannel {
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private byte[] buf;
    private int pos;
    private int last;
    private boolean closed;
    private final boolean readonly;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    ByteArrayChannel(int sz, boolean readonly) {
        this.buf = new byte[sz];
        this.last = 0;
        this.pos = 0;
        this.readonly = readonly;
    }

    ByteArrayChannel(byte[] buf, boolean readonly) {
        this.buf = buf;
        this.pos = 0;
        this.last = buf.length;
        this.readonly = readonly;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public long position() throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            long l = this.pos;
            return l;
        }
        finally {
            this.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long position) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            if (position < 0L || position >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Illegal position " + position);
            }
            this.pos = Math.min((int)position, this.last);
            ByteArrayChannel byteArrayChannel = this;
            return byteArrayChannel;
        }
        finally {
            this.endWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.beginWrite();
        try {
            this.ensureOpen();
            if (this.pos == this.last) {
                int n = -1;
                return n;
            }
            int n = Math.min(dst.remaining(), this.last - this.pos);
            dst.put(this.buf, this.pos, n);
            this.pos += n;
            int n2 = n;
            return n2;
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        if (this.readonly) {
            throw new NonWritableChannelException();
        }
        this.ensureOpen();
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.readonly) {
            throw new NonWritableChannelException();
        }
        this.beginWrite();
        try {
            this.ensureOpen();
            int n = src.remaining();
            this.ensureCapacity(this.pos + n);
            src.get(this.buf, this.pos, n);
            this.pos += n;
            if (this.pos > this.last) {
                this.last = this.pos;
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public long size() throws IOException {
        this.beginRead();
        try {
            this.ensureOpen();
            long l = this.last;
            return l;
        }
        finally {
            this.endRead();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.beginWrite();
        try {
            this.closed = true;
            this.buf = null;
            this.pos = 0;
            this.last = 0;
        }
        finally {
            this.endWrite();
        }
    }

    public byte[] toByteArray() {
        this.beginRead();
        try {
            byte[] byArray = Arrays.copyOf(this.buf, this.last);
            return byArray;
        }
        finally {
            this.endRead();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    private void beginWrite() {
        this.rwlock.writeLock().lock();
    }

    private void endWrite() {
        this.rwlock.writeLock().unlock();
    }

    private void beginRead() {
        this.rwlock.readLock().lock();
    }

    private void endRead() {
        this.rwlock.readLock().unlock();
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ByteArrayChannel.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

