/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.jdk.Target_sun_nio_fs_WindowsFileSystem;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.WINDOWS.class})
class WindowsFileSystemAccessors {
    WindowsFileSystemAccessors() {
    }

    static String getDefaultDirectory(Target_sun_nio_fs_WindowsFileSystem that) {
        if (that.needsReinitialization != 0) {
            WindowsFileSystemAccessors.reinitialize(that);
        }
        return that.injectedDefaultDirectory;
    }

    static String getDefaultRoot(Target_sun_nio_fs_WindowsFileSystem that) {
        if (that.needsReinitialization != 0) {
            WindowsFileSystemAccessors.reinitialize(that);
        }
        return that.injectedDefaultRoot;
    }

    static void setDefaultDirectory(Target_sun_nio_fs_WindowsFileSystem that, String value) {
        that.injectedDefaultDirectory = value;
    }

    static void setDefaultRoot(Target_sun_nio_fs_WindowsFileSystem that, String value) {
        that.injectedDefaultRoot = value;
    }

    private static synchronized void reinitialize(Target_sun_nio_fs_WindowsFileSystem that) {
        if (that.needsReinitialization != 2) {
            return;
        }
        that.needsReinitialization = 1;
        that.originalConstructor(that.provider, ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).userDir());
        that.needsReinitialization = 0;
    }
}

