/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class CodeReferenceMapDecoder {
    /*
     * Unable to fully structure code
     */
    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean walkOffsetsFromPointer(PointerBase baseAddress, NonmovableArray<Byte> referenceMapEncoding, long referenceMapIndex, ObjectReferenceVisitor visitor, Object holderObject) {
        if (!CodeReferenceMapDecoder.$assertionsDisabled && referenceMapIndex == -1L) {
            throw new AssertionError();
        }
        if (!CodeReferenceMapDecoder.$assertionsDisabled && !referenceMapEncoding.isNonNull()) {
            throw new AssertionError();
        }
        uncompressedSize = WordFactory.unsigned((int)FrameAccess.uncompressedReferenceSize());
        compressedSize = WordFactory.unsigned((int)ConfigurationValues.getObjectLayout().getReferenceSize());
        objRef = (Pointer)baseAddress;
        idx = referenceMapIndex;
        firstRun = true;
        block0: while (true) {
            if ((gap = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                shift = 6L;
                i = 2;
                while (true) {
                    b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                    gap += b << (int)shift;
                    if (b < 192L || (long)i == 11L) break;
                    shift += 6L;
                    ++i;
                }
            }
            gap = CodeReferenceMapDecoder.decodeSign(gap);
            if ((count = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                shift = 6L;
                i = 2;
                while (true) {
                    b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                    count += b << (int)shift;
                    if (b < 192L || (long)i == 11L) break;
                    shift += 6L;
                    ++i;
                }
            }
            count = CodeReferenceMapDecoder.decodeSign(count);
            if (gap == 0L && count == 0L) break;
            derived = false;
            if (!firstRun && gap < 0L) {
                gap = -(gap + 1L);
                derived = true;
            }
            firstRun = false;
            objRef = objRef.add(WordFactory.unsigned((long)gap));
            compressed = count < 0L;
            refSize = compressed != false ? compressedSize : uncompressedSize;
            v0 = count = count < 0L ? -count : count;
            if (derived) {
                v1 = basePtr = baseAddress.isNull() != false ? objRef : (Pointer)objRef.readWord(0);
                if (!CodeReferenceMapDecoder.callVisitObjectReferenceInline(visitor, objRef, 0, compressed, holderObject)) {
                    return false;
                }
                for (d = 0L; d < count; ++d) {
                    if ((refOffset = (long)NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++)) >= 192L) {
                        shift = 6L;
                        i = 2;
                        while (true) {
                            b = NonmovableByteArrayReader.getU1(referenceMapEncoding, idx++);
                            refOffset += b << (int)shift;
                            if (b < 192L || (long)i == 11L) break;
                            shift += 6L;
                            ++i;
                        }
                    }
                    derivedRef = (refOffset = CodeReferenceMapDecoder.decodeSign(refOffset)) >= 0L ? objRef.add(WordFactory.unsigned((long)refOffset).multiply(refSize)) : objRef.subtract(WordFactory.unsigned((long)(-refOffset)).multiply(refSize));
                    derivedPtr = baseAddress.isNull() != false ? derivedRef : (Pointer)derivedRef.readWord(0);
                    innerOffsetRaw = derivedPtr.subtract((UnsignedWord)basePtr).rawValue();
                    innerOffset = (int)innerOffsetRaw;
                    if (!CodeReferenceMapDecoder.$assertionsDisabled && (long)innerOffset != innerOffsetRaw) {
                        throw new AssertionError();
                    }
                    if (CodeReferenceMapDecoder.callVisitObjectReferenceInline(visitor, derivedRef, innerOffset, compressed, holderObject)) continue;
                    return false;
                }
                objRef = objRef.add(refSize);
                continue;
            }
            c = 0L;
            while (true) {
                if (c < count) ** break;
                continue block0;
                if (!CodeReferenceMapDecoder.callVisitObjectReferenceInline(visitor, objRef, 0, compressed, holderObject)) {
                    return false;
                }
                objRef = objRef.add(refSize);
                ++c;
            }
            break;
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long decodeSign(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static boolean callVisitObjectReferenceInline(ObjectReferenceVisitor visitor, Pointer derivedRef, int innerOffset, boolean compressed, Object holderObject) {
        return visitor.visitObjectReferenceInline(derivedRef, innerOffset, compressed, holderObject);
    }
}

