/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.nodes.SafepointCheckNode;
import com.oracle.svm.core.thread.Safepoint;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

final class SafepointSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    private static void safepointSnippet() {
        boolean needSlowPath = SafepointCheckNode.test();
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)needSlowPath)) {
            SafepointSnippets.callSlowPathSafepointCheck(Safepoint.ENTER_SLOW_PATH_SAFEPOINT_CHECK);
        }
    }

    SafepointSnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(SafepointNode.class, new SafepointLowering());
    }

    private static LocationIdentity[] getKilledLocations() {
        int newLength = SubstrateAllocationSnippets.TLAB_LOCATIONS.length + 1;
        LocationIdentity[] locations = Arrays.copyOf(SubstrateAllocationSnippets.TLAB_LOCATIONS, newLength);
        locations[newLength - 1] = Safepoint.getThreadLocalSafepointRequestedLocationIdentity();
        return locations;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void callSlowPathSafepointCheck(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    class SafepointLowering
    implements NodeLoweringProvider<SafepointNode> {
        private final SnippetTemplate.SnippetInfo safepoint;

        SafepointLowering() {
            this.safepoint = SafepointSnippets.this.snippet(SafepointSnippets.class, "safepointSnippet", SafepointSnippets.getKilledLocations());
        }

        @Override
        public void lower(SafepointNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.LOW_TIER) {
                assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "safepoints are only inserted into the graph in MultiThreaded mode";
                if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)node.graph().method())) {
                    throw GraalError.shouldNotReachHere((String)("Must not insert safepoints in Uninterruptible code: " + node.stateBefore().toString(Verbosity.Debugger)));
                }
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.safepoint, node.graph().getGuardsStage(), tool.getLoweringStage());
                SafepointSnippets.this.template((ValueNode)node, args).instantiate(SafepointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
            }
        }
    }
}

