/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.SubstrateSegfaultHandlerStartupHook;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class SubstrateSegfaultHandlerFeature
implements Feature {
    SubstrateSegfaultHandlerFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ImageSingletons.contains(SubstrateSegfaultHandler.class)) {
            return;
        }
        SubstrateSegfaultHandler.SingleIsolateSegfaultSetup singleIsolateSegfaultSetup = new SubstrateSegfaultHandler.SingleIsolateSegfaultSetup();
        ImageSingletons.add(SubstrateSegfaultHandler.SingleIsolateSegfaultSetup.class, (Object)singleIsolateSegfaultSetup);
        IsolateListenerSupport.singleton().register(singleIsolateSegfaultSetup);
        VMError.guarantee(ImageSingletons.contains(RegisterDumper.class));
        RuntimeSupport.getRuntimeSupport().addStartupHook(new SubstrateSegfaultHandlerStartupHook());
    }
}

