/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

public class ReflectionDataBuilder
implements RuntimeReflectionSupport {
    public static final Field[] EMPTY_FIELDS = new Field[0];
    public static final Method[] EMPTY_METHODS = new Method[0];
    public static final Constructor<?>[] EMPTY_CONSTRUCTORS = new Constructor[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private boolean modified;
    private boolean sealed;
    private final DynamicHub.ReflectionData arrayReflectionData;
    private final Set<Class<?>> reflectionClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Executable> reflectionMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Field, EnumSet<FieldFlag>> reflectionFields = new ConcurrentHashMap<Field, EnumSet<FieldFlag>>();
    private final Set<Field> analyzedFinalFields = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Field> preregisteredAsWritable = ConcurrentHashMap.newKeySet();
    private final Set<Class<?>> processedClasses = new HashSet();
    private final ReflectionDataAccessors accessors;

    public ReflectionDataBuilder(FeatureImpl.DuringSetupAccessImpl access) {
        this.arrayReflectionData = ReflectionDataBuilder.getArrayReflectionData();
        this.accessors = new ReflectionDataAccessors(access);
    }

    private static DynamicHub.ReflectionData getArrayReflectionData() {
        Method[] publicArrayMethods;
        try {
            Method getPublicMethodsMethod = ReflectionUtil.lookupMethod(Class.class, (String)"privateGetPublicMethods", (Class[])new Class[0]);
            publicArrayMethods = (Method[])getPublicMethodsMethod.invoke(Object[].class, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        return new DynamicHub.ReflectionData(EMPTY_FIELDS, EMPTY_FIELDS, EMPTY_FIELDS, EMPTY_METHODS, publicArrayMethods, EMPTY_CONSTRUCTORS, EMPTY_CONSTRUCTORS, null, EMPTY_FIELDS, EMPTY_METHODS, EMPTY_CLASSES, EMPTY_CLASSES, null, null);
    }

    public void register(Class<?> ... classes) {
        this.checkNotSealed();
        if (this.reflectionClasses.addAll(Arrays.asList(classes))) {
            this.modified = true;
        }
    }

    public void register(Executable ... methods) {
        this.checkNotSealed();
        if (this.reflectionMethods.addAll(Arrays.asList(methods))) {
            this.modified = true;
        }
    }

    public void register(boolean finalIsWritable, boolean allowUnsafeAccess, Field ... fields) {
        this.checkNotSealed();
        for (Field field : fields) {
            EnumSet<FieldFlag> flags = EnumSet.noneOf(FieldFlag.class);
            if (finalIsWritable || this.preregisteredAsWritable.contains(field)) {
                flags.add(FieldFlag.FINAL_BUT_WRITABLE);
            }
            if (allowUnsafeAccess) {
                flags.add(FieldFlag.UNSAFE_ACCESSIBLE);
            }
            this.reflectionFields.compute(field, (key, existingFlags) -> {
                if (existingFlags == null || !existingFlags.containsAll(flags)) {
                    this.modified = true;
                }
                if (existingFlags != null) {
                    flags.addAll((Collection<FieldFlag>)existingFlags);
                }
                if (finalIsWritable && (existingFlags == null || !existingFlags.contains((Object)FieldFlag.FINAL_BUT_WRITABLE))) {
                    UserError.guarantee(!this.analyzedFinalFields.contains(field), "A field that was already processed by the analysis cannot be re-registered as writable: %s", field);
                }
                return flags;
            });
        }
    }

    private void checkNotSealed() {
        if (this.sealed) {
            throw UserError.abort("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
        }
    }

    protected void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.processReachableTypes(access);
        this.processRegisteredElements(access);
    }

    private void processReachableTypes(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (AnalysisType type : access.getUniverse().getTypes()) {
            Class originalClass = type.getJavaClass();
            if (originalClass == null || this.processedClasses.contains(originalClass) || type.isArray() && !access.isReachable(type) || !type.isArray() && this.enclosingMethodOrConstructor(originalClass) == null) continue;
            this.processClass(access, originalClass);
            this.processedClasses.add(originalClass);
            access.requireAnalysisIteration();
        }
    }

    private void processRegisteredElements(FeatureImpl.DuringAnalysisAccessImpl access) {
        if (!this.modified) {
            return;
        }
        this.modified = false;
        access.requireAnalysisIteration();
        HashSet allClasses = new HashSet(this.reflectionClasses);
        this.reflectionMethods.stream().map(Executable::getDeclaringClass).forEach(allClasses::add);
        this.reflectionFields.forEach((field, flags) -> {
            if (flags.contains((Object)FieldFlag.UNSAFE_ACCESSIBLE)) {
                access.registerAsUnsafeAccessed((Field)field);
            }
            allClasses.add(field.getDeclaringClass());
        });
        allClasses.forEach(clazz -> this.processClass(access, (Class<?>)clazz));
    }

    private void processClass(FeatureImpl.DuringAnalysisAccessImpl access, Class<?> clazz) {
        if (SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
        type.registerAsReachable();
        DynamicHub hub = access.getHostVM().dynamicHub((ResolvedJavaType)type);
        if (this.reflectionClasses.contains(clazz)) {
            ClassForNameSupport.registerClass(clazz);
        }
        try {
            clazz.getDeclaredFields();
            clazz.getFields();
            clazz.getDeclaredMethods();
            clazz.getMethods();
            clazz.getDeclaredConstructors();
            clazz.getConstructors();
        }
        catch (LinkageError | TypeNotPresentException e) {
            ReflectionDataBuilder.reportLinkingError(clazz, e);
            return;
        }
        Object originalReflectionData = this.accessors.getReflectionData(clazz);
        DynamicHub.ReflectionData reflectionData = type.isArray() ? this.arrayReflectionData : new DynamicHub.ReflectionData(ReflectionDataBuilder.filterFields(this.accessors.getDeclaredFields(originalReflectionData), this.reflectionFields.keySet(), access), ReflectionDataBuilder.filterFields(this.accessors.getPublicFields(originalReflectionData), this.reflectionFields.keySet(), access), ReflectionDataBuilder.filterFields(this.accessors.getPublicFields(originalReflectionData), (Field f) -> this.reflectionFields.containsKey(f) && !ReflectionDataBuilder.isHiddenIn(f, clazz), access), ReflectionDataBuilder.filterMethods(this.accessors.getDeclaredMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterMethods(this.accessors.getPublicMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterConstructors(this.accessors.getDeclaredConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterConstructors(this.accessors.getPublicConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.nullaryConstructor(this.accessors.getDeclaredConstructors(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.filterFields(this.accessors.getDeclaredPublicFields(originalReflectionData), this.reflectionFields.keySet(), access), ReflectionDataBuilder.filterMethods(this.accessors.getDeclaredPublicMethods(originalReflectionData), this.reflectionMethods, access), ReflectionDataBuilder.catchLinkingErrors(clazz, this.reflectionClasses, access, Class::getDeclaredClasses), ReflectionDataBuilder.catchLinkingErrors(clazz, this.reflectionClasses, access, Class::getClasses), this.enclosingMethodOrConstructor(clazz), this.buildRecordComponents(clazz, access));
        hub.setReflectionData(reflectionData);
    }

    private Object[] buildRecordComponents(Class<?> clazz, FeatureImpl.DuringAnalysisAccessImpl access) {
        Method[] filteredMethods;
        RecordSupport support = RecordSupport.singleton();
        if (!support.isRecord(clazz)) {
            return null;
        }
        Method[] allMethods = support.getRecordComponentAccessorMethods(clazz);
        if (allMethods.length == (filteredMethods = ReflectionDataBuilder.filterMethods(allMethods, this.reflectionMethods, access)).length) {
            return support.getRecordComponents(clazz);
        }
        return null;
    }

    private static Class<?>[] catchLinkingErrors(Class<?> clazz, Set<Class<?>> filter, FeatureImpl.DuringAnalysisAccessImpl access, Function<Class<?>, Class<?>[]> innerClassAccessor) {
        try {
            return ReflectionDataBuilder.filterClasses(innerClassAccessor.apply(clazz), filter, access);
        }
        catch (LinkageError | TypeNotPresentException e) {
            ReflectionDataBuilder.reportLinkingError(clazz, e);
            return EMPTY_CLASSES;
        }
    }

    private static void reportLinkingError(Class<?> clazz, Throwable e) {
        System.out.println("WARNING: Could not register reflection metadata for " + clazz.getTypeName() + ". Reason: " + e.getClass().getTypeName() + ": " + e.getMessage() + '.');
    }

    protected void afterAnalysis() {
        this.sealed = true;
        if (this.modified) {
            throw UserError.abort("Registration of classes, methods, and fields for reflective access during analysis must set DuringAnalysisAccess.requireAnalysisIteration().", new Object[0]);
        }
    }

    private static Constructor<?> nullaryConstructor(Object constructors, Set<?> reflectionMethods, FeatureImpl.DuringAnalysisAccessImpl access) {
        for (Constructor constructor : (Constructor[])constructors) {
            if (constructor.getParameterCount() != 0 || !reflectionMethods.contains(constructor) || SubstitutionReflectivityFilter.shouldExclude(constructor, access.getMetaAccess(), access.getUniverse())) continue;
            return constructor;
        }
        return null;
    }

    private Executable enclosingMethodOrConstructor(Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Constructor<?> enclosingConstructor;
        Method enclosingMethod;
        try {
            enclosingMethod = clazz.getEnclosingMethod();
            enclosingConstructor = clazz.getEnclosingConstructor();
        }
        catch (LinkageError | TypeNotPresentException e) {
            return null;
        }
        catch (InternalError ex) {
            return null;
        }
        if (enclosingMethod == null && enclosingConstructor == null) {
            return null;
        }
        if (enclosingMethod != null && enclosingConstructor != null) {
            throw VMError.shouldNotReachHere("Class has both an enclosingMethod and an enclosingConstructor: " + clazz + ", " + enclosingMethod + ", " + enclosingConstructor);
        }
        Executable executable = enclosingMethodOrConstructor = enclosingMethod != null ? enclosingMethod : enclosingConstructor;
        if (this.reflectionMethods.contains(enclosingMethodOrConstructor)) {
            return enclosingMethodOrConstructor;
        }
        return null;
    }

    private static Field[] filterFields(Object fields, Set<Field> filterSet, FeatureImpl.DuringAnalysisAccessImpl access) {
        return ReflectionDataBuilder.filterFields(fields, filterSet::contains, access);
    }

    private static boolean isHiddenIn(Field field, Class<?> clazz) {
        try {
            return !clazz.getField(field.getName()).equals(field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private static Field[] filterFields(Object fields, Predicate<Field> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : (Field[])fields) {
            if (!filter.test(field) || SubstitutionReflectivityFilter.shouldExclude(field, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(field);
        }
        return result.toArray(EMPTY_FIELDS);
    }

    private static Constructor<?>[] filterConstructors(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        return (Constructor[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (FeatureImpl.DuringAnalysisAccessImpl)access, (Executable[])EMPTY_CONSTRUCTORS);
    }

    private static Method[] filterMethods(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        return (Method[])ReflectionDataBuilder.filterMethods((Object)methods, filter, (FeatureImpl.DuringAnalysisAccessImpl)access, (Executable[])EMPTY_METHODS);
    }

    private static <T extends Executable> T[] filterMethods(Object methods, Set<Executable> filter, FeatureImpl.DuringAnalysisAccessImpl access, T[] prototypeArray) {
        ArrayList<Executable> result = new ArrayList<Executable>();
        for (Executable method : (Executable[])methods) {
            if (!filter.contains(method) || SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(method);
        }
        return (Executable[])result.toArray(prototypeArray);
    }

    private static Class<?>[] filterClasses(Object classes, Set<Class<?>> filter, FeatureImpl.DuringAnalysisAccessImpl access) {
        ArrayList<Class> result = new ArrayList<Class>();
        for (Class clazz : (Class[])classes) {
            if (!filter.contains(clazz) || SubstitutionReflectivityFilter.shouldExclude(clazz, access.getMetaAccess(), access.getUniverse())) continue;
            result.add(clazz);
        }
        return result.toArray(EMPTY_CLASSES);
    }

    public boolean inspectFinalFieldWritableForAnalysis(Field field) {
        if (field == null || !Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        EnumSet<FieldFlag> flags = this.reflectionFields.get(field);
        this.analyzedFinalFields.add(field);
        return flags != null && flags.contains((Object)FieldFlag.FINAL_BUT_WRITABLE) || this.preregisteredAsWritable.contains(field);
    }

    public void preregisterAsWritableForAnalysis(Field field) {
        UserError.guarantee(!this.analyzedFinalFields.contains(field), "A field that was already processed by the analysis cannot be preregistered as writable: %s", field);
        this.preregisteredAsWritable.add(field);
    }

    static final class ReflectionDataAccessors {
        private final Method reflectionDataMethod = ReflectionUtil.lookupMethod(Class.class, (String)"reflectionData", (Class[])new Class[0]);
        private final Field declaredFieldsField;
        private final Field publicFieldsField;
        private final Field declaredMethodsField;
        private final Field publicMethodsField;
        private final Field declaredConstructorsField;
        private final Field publicConstructorsField;
        private final Field declaredPublicFieldsField;
        private final Field declaredPublicMethodsField;

        ReflectionDataAccessors(FeatureImpl.DuringSetupAccessImpl access) {
            Class<?> originalReflectionDataClass = access.getImageClassLoader().findClassOrFail("java.lang.Class$ReflectionData");
            this.declaredFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredFields");
            this.publicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicFields");
            this.declaredMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredMethods");
            this.publicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicMethods");
            this.declaredConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredConstructors");
            this.publicConstructorsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"publicConstructors");
            this.declaredPublicFieldsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicFields");
            this.declaredPublicMethodsField = ReflectionUtil.lookupField(originalReflectionDataClass, (String)"declaredPublicMethods");
        }

        public Object getReflectionData(Class<?> clazz) {
            try {
                return this.reflectionDataMethod.invoke(clazz, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredFields(Object obj) {
            try {
                return this.declaredFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicFields(Object obj) {
            try {
                return this.publicFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredMethods(Object obj) {
            try {
                return this.declaredMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicMethods(Object obj) {
            try {
                return this.publicMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredConstructors(Object obj) {
            try {
                return this.declaredConstructorsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getPublicConstructors(Object obj) {
            try {
                return this.publicConstructorsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredPublicFields(Object obj) {
            try {
                return this.declaredPublicFieldsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        public Object getDeclaredPublicMethods(Object obj) {
            try {
                return this.declaredPublicMethodsField.get(obj);
            }
            catch (IllegalAccessException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }

    private static enum FieldFlag {
        FINAL_BUT_WRITABLE,
        UNSAFE_ACCESSIBLE;

    }
}

