/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Iterator;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.Wrapper;

@AutomaticFeature
public class MethodHandleFeature
implements Feature {
    private boolean analysisFinished = false;
    private Class<?> directMethodHandleClass;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.areMethodHandlesSupported();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        this.directMethodHandleClass = access.findClassByName("java.lang.invoke.DirectMethodHandle");
        access.registerObjectReplacer(this::registerMethodHandle);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"createFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplConstantHandlesForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"makeConstantHandle", (Class[])new Class[]{Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerMHImplCountingWrapperFunctionsForReflection, new Object[]{access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper")});
        access.registerReachabilityHandler(MethodHandleFeature::registerInvokersFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.Invokers"), (String)"createFunction", (Class[])new Class[]{Byte.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionBoxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"boxExact", (Class[])new Class[]{Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionUnboxFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"unbox", (Class[])new Class[]{Wrapper.class, Integer.TYPE})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionConvertFunctionsForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"convertPrimitive", (Class[])new Class[]{Wrapper.class, Wrapper.class})});
        access.registerReachabilityHandler(MethodHandleFeature::registerValueConversionIgnoreForReflection, new Object[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[0])});
        access.registerClassInitializerReachabilityHandler(MethodHandleFeature::registerDelegatingMHFunctionsForReflection, access.findClassByName("java.lang.invoke.DelegatingMethodHandle"));
        access.registerReachabilityHandler(MethodHandleFeature::registerCallSiteGetTargetForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTargetHandle", (Class[])new Class[0])});
        access.registerReachabilityHandler(MethodHandleFeature::registerUninitializedCallSiteForReflection, new Object[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSiteHandle", (Class[])new Class[0])});
        access.registerSubtypeReachabilityHandler(MethodHandleFeature::registerVarHandleMethodsForReflection, access.findClassByName("java.lang.invoke.VarHandle"));
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.analysisFinished = true;
    }

    private static void registerMHImplFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"checkSpreadArgument", (Class[])new Class[]{Object.class, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"guardWithCatch", (Class[])new Class[]{MethodHandle.class, Class.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"tryFinally", (Class[])new Class[]{MethodHandle.class, MethodHandle.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"loop", (Class[])new Class[]{access.findClassByName("[Ljava.lang.invoke.LambdaForm$BasicType;"), access.findClassByName("java.lang.invoke.MethodHandleImpl$LoopClauses"), Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"throwException", (Class[])new Class[]{Throwable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"profileBoolean", (Class[])new Class[]{Boolean.TYPE, int[].class})});
    }

    private static void registerMHImplConstantHandlesForReflection(Feature.DuringAnalysisAccess access) {
        Class mhImplClazz = access.findClassByName("java.lang.invoke.MethodHandleImpl");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"copyAsPrimitiveArray", (Class[])new Class[]{access.findClassByName("sun.invoke.util.Wrapper"), Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"identity", (Class[])new Class[]{Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"fillNewArray", (Class[])new Class[]{Integer.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"fillNewTypedArray", (Class[])new Class[]{Object[].class, Integer.class, Object[].class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"selectAlternative", (Class[])new Class[]{Boolean.TYPE, MethodHandle.class, MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopPredicate", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"countedLoopStep", (Class[])new Class[]{Integer.TYPE, Integer.TYPE})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"initIterator", (Class[])new Class[]{Iterable.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iteratePredicate", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)mhImplClazz, (String)"iterateNext", (Class[])new Class[]{Iterator.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(Array.class, (String)"newInstance", (Class[])new Class[]{Class.class, Integer.TYPE})});
    }

    private static void registerMHImplCountingWrapperFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)access.findClassByName("java.lang.invoke.MethodHandleImpl$CountingWrapper"), (String)"maybeStopCounting", (Class[])new Class[]{Object.class})});
    }

    private static void registerInvokersFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class invokersClazz = access.findClassByName("java.lang.invoke.Invokers");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkExactType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkGenericType", (Class[])new Class[]{MethodHandle.class, MethodType.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"getCallSiteTarget", (Class[])new Class[]{CallSite.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkCustomized", (Class[])new Class[]{MethodHandle.class})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleGenericType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)invokersClazz, (String)"checkVarHandleExactType", (Class[])new Class[]{access.findClassByName("java.lang.invoke.VarHandle"), access.findClassByName("java.lang.invoke.VarHandle$AccessDescriptor")})});
    }

    private static void registerValueConversionBoxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("box" + type.wrapperSimpleName()), (Class[])new Class[]{type.primitiveType()})});
        }
    }

    private static void registerValueConversionUnboxFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper type : Wrapper.values()) {
            if (!type.primitiveType().isPrimitive() || type == Wrapper.VOID) continue;
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{type.wrapperType()})});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)("unbox" + type.wrapperSimpleName()), (Class[])new Class[]{Object.class, Boolean.TYPE})});
        }
    }

    private static void registerValueConversionConvertFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        for (Wrapper src : Wrapper.values()) {
            for (Wrapper dest : Wrapper.values()) {
                if (src == dest || !src.primitiveType().isPrimitive() || src == Wrapper.VOID || !dest.primitiveType().isPrimitive() || dest == Wrapper.VOID) continue;
                RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)MethodHandleFeature.valueConverterName(src, dest), (Class[])new Class[]{src.primitiveType()})});
            }
        }
    }

    private static String valueConverterName(Wrapper src, Wrapper dest) {
        String srcType = src.primitiveSimpleName();
        String destType = dest.primitiveSimpleName();
        return srcType + "To" + destType.substring(0, 1).toUpperCase() + destType.substring(1);
    }

    private static void registerValueConversionIgnoreForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(ValueConversions.class, (String)"ignore", (Class[])new Class[]{Object.class})});
    }

    private static void registerDelegatingMHFunctionsForReflection(Feature.DuringAnalysisAccess access) {
        Class delegatingMHClazz = access.findClassByName("java.lang.invoke.DelegatingMethodHandle");
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)delegatingMHClazz, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerCallSiteGetTargetForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"getTarget", (Class[])new Class[0])});
    }

    private static void registerUninitializedCallSiteForReflection(Feature.DuringAnalysisAccess access) {
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod(CallSite.class, (String)"uninitializedCallSite", (Class[])new Class[]{Object[].class})});
    }

    private static void registerVarHandleMethodsForReflection(Feature.DuringAnalysisAccess access, Class<?> subtype) {
        if (subtype.getPackage().getName().equals("java.lang.invoke") && subtype != access.findClassByName("java.lang.invoke.VarHandle")) {
            RuntimeReflection.register((Executable[])subtype.getDeclaredMethods());
        }
    }

    private Object registerMethodHandle(Object obj) {
        block5: {
            if (!this.analysisFinished && this.directMethodHandleClass.isAssignableFrom(obj.getClass())) {
                MethodHandle handle = (MethodHandle)obj;
                try {
                    Member member = MethodHandles.reflectAs(Member.class, handle);
                    if (member instanceof Executable) {
                        RuntimeReflection.register((Executable[])new Executable[]{(Executable)member});
                        break block5;
                    }
                    if (member instanceof Field) {
                        RuntimeReflection.register((Field[])new Field[]{(Field)member});
                        break block5;
                    }
                    throw VMError.shouldNotReachHere("Unexpected reflected type " + member.getClass());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return obj;
    }
}

