/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;

public class IntrinsificationPluginRegistry {
    private static final Object NULL_MARKER = new Object();
    private final ConcurrentHashMap<CallSiteDescriptor, Object> globalAnalysisElements = new ConcurrentHashMap();
    public final Set<AnalysisMethod> methodsWithIntrinsification = ConcurrentHashMap.newKeySet();
    public final ThreadLocal<ConcurrentHashMap<CallSiteDescriptor, Object>> threadLocalRegistry = new ThreadLocal();

    public static AutoCloseable startThreadLocalRegistry(final IntrinsificationPluginRegistry registry) {
        return new AutoCloseable(){
            {
                assert (registry.threadLocalRegistry.get() == null);
                registry.threadLocalRegistry.set(new ConcurrentHashMap());
            }

            @Override
            public void close() {
                registry.threadLocalRegistry.set(null);
            }
        };
    }

    public static AutoCloseable pauseThreadLocalRegistry(final IntrinsificationPluginRegistry registry) {
        return new AutoCloseable(){
            final ConcurrentHashMap<CallSiteDescriptor, Object> threadLocalRegistryBackup;
            {
                this.threadLocalRegistryBackup = registry.threadLocalRegistry.get();
                registry.threadLocalRegistry.set(null);
            }

            @Override
            public void close() {
                registry.threadLocalRegistry.set(this.threadLocalRegistryBackup);
            }
        };
    }

    private ConcurrentHashMap<CallSiteDescriptor, Object> getAnalysisElements() {
        return this.threadLocalRegistry.get() == null ? this.globalAnalysisElements : this.threadLocalRegistry.get();
    }

    public void add(List<Pair<ResolvedJavaMethod, Integer>> callingContext, Object element) {
        Object nonNullElement = element != null ? element : NULL_MARKER;
        Object previous = this.getAnalysisElements().putIfAbsent(new CallSiteDescriptor(callingContext), nonNullElement);
        VMError.guarantee(previous == null || previous == nonNullElement, "Newly intrinsified element is different than the previous");
        this.methodsWithIntrinsification.add((AnalysisMethod)callingContext.get(0).getLeft());
    }

    public <T> T get(List<Pair<ResolvedJavaMethod, Integer>> callingContext) {
        Object nonNullElement = this.getAnalysisElements().get(new CallSiteDescriptor(callingContext));
        return (T)(nonNullElement != NULL_MARKER ? nonNullElement : null);
    }

    public boolean hasIntrinsifications(AnalysisMethod method) {
        return this.methodsWithIntrinsification.contains(method);
    }

    public static class CallSiteDescriptor {
        private final AnalysisMethod[] caller;
        private final int[] bci;
        private final int length;

        public CallSiteDescriptor(List<Pair<ResolvedJavaMethod, Integer>> callingContext) {
            this.length = callingContext.size();
            this.caller = new AnalysisMethod[this.length];
            this.bci = new int[this.length];
            int i = 0;
            for (Pair<ResolvedJavaMethod, Integer> pair : callingContext) {
                this.caller[i] = CallSiteDescriptor.toAnalysisMethod((ResolvedJavaMethod)pair.getLeft());
                this.bci[i] = (Integer)pair.getRight();
                ++i;
            }
        }

        public AnalysisMethod[] getCaller() {
            return this.caller;
        }

        public int[] getBci() {
            return this.bci;
        }

        public int getLength() {
            return this.length;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallSiteDescriptor) {
                CallSiteDescriptor other = (CallSiteDescriptor)obj;
                return Arrays.equals(this.bci, other.bci) && Arrays.equals(this.caller, other.caller);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.caller) ^ Arrays.hashCode(this.bci);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.caller.length; ++i) {
                sb.append(this.caller[i].format("%h.%n(%p)")).append("@").append(this.bci[i]).append(System.lineSeparator());
            }
            return sb.toString();
        }

        private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
            if (method instanceof HostedMethod) {
                return ((HostedMethod)method).wrapped;
            }
            VMError.guarantee(method instanceof AnalysisMethod);
            return (AnalysisMethod)method;
        }
    }
}

