/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.agent;

import com.oracle.svm.hosted.agent.ClinitGenerationVisitor;
import com.oracle.svm.hosted.agent.TracingAdvisor;
import com.oracle.svm.hosted.agent.jdk8.lambda.LambdaMetaFactoryRewriteVisitor;
import com.oracle.svm.util.AgentSupport;
import java.lang.instrument.Instrumentation;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;

public class NativeImageBytecodeInstrumentationAgent {
    private static TracingAdvisor advisor;

    public static void premain(String agentArgs, Instrumentation inst) {
        if (NativeImageBytecodeInstrumentationAgent.getJavaVersion() == 8) {
            inst.addTransformer(AgentSupport.createClassInstrumentationTransformer(NativeImageBytecodeInstrumentationAgent::applyRewriteLambdasTransformation));
        }
        if (agentArgs != null && !agentArgs.isEmpty()) {
            advisor = new TracingAdvisor(agentArgs);
            inst.addTransformer(AgentSupport.createClassInstrumentationTransformer(NativeImageBytecodeInstrumentationAgent::applyInitializationTrackingTransformation));
        }
    }

    private static byte[] applyInitializationTrackingTransformation(String moduleName, ClassLoader loader, String className, byte[] classfileBuffer) {
        if (advisor.shouldTraceClassInitialization(className.replace('/', '.'))) {
            ClassReader reader = new ClassReader(classfileBuffer);
            ClassWriter writer = new ClassWriter(reader, 2);
            ClinitGenerationVisitor visitor = new ClinitGenerationVisitor(writer);
            reader.accept(visitor, 0);
            return writer.toByteArray();
        }
        return classfileBuffer;
    }

    private static byte[] applyRewriteLambdasTransformation(String moduleName, ClassLoader loader, String className, byte[] classfileBuffer) {
        ClassReader reader = new ClassReader(classfileBuffer);
        ClassWriter writer = new ClassWriter(reader, 1);
        LambdaMetaFactoryRewriteVisitor visitor = new LambdaMetaFactoryRewriteVisitor(loader, className, writer);
        reader.accept(visitor, 8);
        return writer.toByteArray();
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dash;
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
            if ((dash = version.indexOf("-")) != -1) {
                version = version.substring(0, dash);
            }
        }
        return Integer.parseInt(version);
    }
}

