/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.heap.StoredContinuationImpl;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import com.oracle.svm.core.thread.Target_java_lang_ContinuationScope;
import com.oracle.svm.core.thread.Target_java_lang_Thread;
import com.oracle.svm.core.thread.Target_java_lang_Thread_FieldHolder;
import com.oracle.svm.core.thread.Target_java_lang_VirtualThread;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class JavaContinuations {
    public static final int YIELDING = -2;
    public static final int YIELD_SUCCESS = 0;
    public static final int PINNED_CRITICAL_SECTION = 1;
    public static final int PINNED_NATIVE = 2;
    public static final int PINNED_MONITOR = 3;

    @Fold
    public static boolean useLoom() {
        return SubstrateOptions.UseLoom.getValue();
    }

    @NeverInline(value="access stack pointer")
    public static Integer yield(Target_java_lang_Continuation cont) {
        Pointer leafSP = KnownIntrinsics.readCallerStackPointer();
        Pointer rootSP = cont.sp;
        CodePointer leafIP = KnownIntrinsics.readReturnAddress();
        CodePointer rootIP = cont.ip;
        int preemptStatus = StoredContinuationImpl.allocateFromCurrentStack(cont, rootSP, leafSP, leafIP);
        if (preemptStatus != 0) {
            return preemptStatus;
        }
        cont.sp = leafSP;
        cont.ip = leafIP;
        KnownIntrinsics.farReturn(0, rootSP, rootIP, false);
        throw VMError.shouldNotReachHere("value should be returned by `farReturn`");
    }

    public static int tryPreempt(Target_java_lang_Continuation cont, Thread thread) {
        TryPreemptThunk thunk = new TryPreemptThunk(cont, thread);
        JavaVMOperation.enqueueBlockingSafepoint("tryForceYield0", thunk);
        return thunk.preemptStatus;
    }

    public static int isPinned(Target_java_lang_Thread thread, Target_java_lang_ContinuationScope scope, boolean isCurrentThread) {
        IsolateThread vmThread;
        Target_java_lang_Continuation cont = thread.getContinuation();
        IsolateThread isolateThread = vmThread = isCurrentThread ? CurrentIsolate.getCurrentThread() : JavaThreads.getIsolateThread(SubstrateUtil.cast(thread, Thread.class));
        if (cont != null) {
            int threadMonitorCount = MonitorSupport.singleton().countThreadLock(vmThread);
            while (true) {
                if (cont.cs > 0) {
                    return 1;
                }
                if (threadMonitorCount > cont.monitorBefore) {
                    return 3;
                }
                if (cont.getParent() == null || cont.getScope() == scope) break;
                cont = cont.getParent();
            }
            JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(vmThread);
            if (anchor.isNonNull() && cont.sp.aboveThan((UnsignedWord)anchor.getLastJavaSP())) {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isStarted(Target_java_lang_Continuation cont) {
        return cont.isStarted();
    }

    public static Pointer getSP(Target_java_lang_Continuation cont) {
        return cont.sp;
    }

    public static CodePointer getIP(Target_java_lang_Continuation cont) {
        return cont.ip;
    }

    public static void setIP(Target_java_lang_Continuation cont, CodePointer ip) {
        cont.ip = ip;
    }

    public static Target_java_lang_Continuation getContinuation(Target_java_lang_Thread thread) {
        if (thread.isVirtual()) {
            Target_java_lang_VirtualThread vthread = SubstrateUtil.cast(thread, Target_java_lang_VirtualThread.class);
            return vthread.cont;
        }
        return thread.cont;
    }

    public static class LoomCompatibilityUtil {
        static long getStackSize(Target_java_lang_Thread tjlt) {
            return JavaContinuations.useLoom() ? tjlt.holder.stackSize : tjlt.stackSize;
        }

        static int getThreadStatus(Target_java_lang_Thread tjlt) {
            return JavaContinuations.useLoom() ? tjlt.holder.threadStatus : tjlt.threadStatus;
        }

        static void setThreadStatus(Target_java_lang_Thread tjlt, int threadStatus) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.threadStatus = threadStatus;
            } else {
                tjlt.threadStatus = threadStatus;
            }
        }

        static int getPriority(Target_java_lang_Thread tjlt) {
            if (JavaContinuations.useLoom()) {
                return tjlt.holder.priority;
            }
            return tjlt.priority;
        }

        static void setPriority(Target_java_lang_Thread tjlt, int priority) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.priority = priority;
            } else {
                tjlt.priority = priority;
            }
        }

        static void setStackSize(Target_java_lang_Thread tjlt, long stackSize) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.stackSize = stackSize;
            } else {
                tjlt.stackSize = stackSize;
            }
        }

        static void setDaemon(Target_java_lang_Thread tjlt, boolean isDaemon) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.daemon = isDaemon;
            } else {
                tjlt.daemon = isDaemon;
            }
        }

        static void setGroup(Target_java_lang_Thread tjlt, ThreadGroup group) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.group = group;
            } else {
                tjlt.group = group;
            }
        }

        static void setTarget(Target_java_lang_Thread tjlt, Runnable target) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder.task = target;
            } else {
                tjlt.target = target;
            }
        }

        static void initThreadFields(Target_java_lang_Thread tjlt, ThreadGroup group, Runnable target, long stackSize, int priority, boolean daemon, int threadStatus) {
            if (JavaContinuations.useLoom()) {
                tjlt.holder = new Target_java_lang_Thread_FieldHolder(null, null, 0L, 0, false);
            }
            LoomCompatibilityUtil.setGroup(tjlt, group);
            LoomCompatibilityUtil.setPriority(tjlt, priority);
            LoomCompatibilityUtil.setDaemon(tjlt, daemon);
            LoomCompatibilityUtil.setTarget(tjlt, target);
            tjlt.setPriority(priority);
            LoomCompatibilityUtil.setStackSize(tjlt, stackSize);
            LoomCompatibilityUtil.setThreadStatus(tjlt, threadStatus);
        }
    }

    private static class TryPreemptThunk
    implements SubstrateUtil.Thunk {
        int preemptStatus = 0;
        final Target_java_lang_Continuation cont;
        final Thread thread;

        TryPreemptThunk(Target_java_lang_Continuation cont, Thread thread) {
            this.cont = cont;
            this.thread = thread;
        }

        @Override
        public void invoke() {
            IsolateThread vmThread = JavaThreads.getIsolateThread(this.thread);
            Pointer rootSP = this.cont.sp;
            CodePointer rootIP = this.cont.ip;
            this.preemptStatus = StoredContinuationImpl.allocateFromForeignStack(this.cont, rootSP, vmThread);
            if (this.preemptStatus == 0) {
                VMThreads.ActionOnExitSafepointSupport.setSwitchStack(vmThread);
                VMThreads.ActionOnExitSafepointSupport.setSwitchStackTarget(vmThread, rootSP, rootIP);
            }
        }
    }
}

