/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.monitor.MonitorSupport;
import com.oracle.svm.core.monitor.Target_java_lang_ref_ReferenceQueue_Lock;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_AbstractOwnableSynchronizer;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_AbstractQueuedSynchronizer;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_ReentrantLock;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_ReentrantLock_NonfairSync;
import com.oracle.svm.core.monitor.Target_java_util_concurrent_locks_ReentrantLock_Sync;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.misc.Unsafe;

public class MultiThreadedMonitorSupport
extends MonitorSupport {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    protected static final FastThreadLocalInt lockedMonitors = FastThreadLocalFactory.createInt();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final Set<Class<?>> FORCE_MONITOR_SLOT_TYPES;
    static final AbstractQueuedSynchronizer.ConditionObject MONITOR_WITHOUT_CONDITION;
    private static long SYNC_MONITOR_CONDITION_FIELD_OFFSET;
    private static long SYNC_STATE_FIELD_OFFSET;
    private final Map<Object, ReentrantLock> additionalMonitors = new WeakIdentityHashMap<Object, ReentrantLock>();
    private final ReentrantLock additionalMonitorsLock = new ReentrantLock();
    protected static final String NO_LONGER_UNINTERRUPTIBLE = "The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too";

    protected static void onMonitorLocked() {
        if (JavaContinuations.useLoom()) {
            lockedMonitors.set(lockedMonitors.get() + 1);
        }
    }

    protected static void onMonitorUnlocked() {
        if (JavaContinuations.useLoom()) {
            lockedMonitors.set(lockedMonitors.get() - 1);
        }
    }

    @Override
    public int maybeAdjustNewParkStatus(int status) {
        Object blocker = LockSupport.getBlocker(Thread.currentThread());
        if (MultiThreadedMonitorSupport.isMonitorCondition(blocker)) {
            if (status == 673) {
                return 417;
            }
            return 401;
        }
        if (MultiThreadedMonitorSupport.isMonitorLockSynchronizer(blocker)) {
            return 1025;
        }
        return status;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorEnter(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        VMOperationControl.guaranteeOkayToBlock("No Java synchronization must be performed within a VMOperation: if the object is already locked, the VM is deadlocked");
        try {
            MultiThreadedMonitorSupport.singleton().monitorEnter(obj);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorEnter", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", overridesCallers=true, access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorEnter(Object obj) {
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, true);
        lockObject.lock();
        MultiThreadedMonitorSupport.onMonitorLocked();
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="Avoid stack overflow error before yellow zone has been activated", calleeMustBe=false)
    private static void slowPathMonitorExit(Object obj) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            MultiThreadedMonitorSupport.singleton().monitorExit(obj);
        }
        catch (OutOfMemoryError ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Unexpected exception in MonitorSupport.monitorExit", ex);
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Override
    @RestrictHeapAccess(reason="The monitor snippet slow path is uninterruptible to avoid stack overflow errors being thrown. Now the yellow zone is enabled and we are no longer uninterruptible, and allocation is allowed again too", overridesCallers=true, access=RestrictHeapAccess.Access.UNRESTRICTED)
    public void monitorExit(Object obj) {
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, true);
        lockObject.unlock();
        MultiThreadedMonitorSupport.onMonitorUnlocked();
    }

    @Override
    public Object prepareRelockObject(Object obj) {
        return this.getOrCreateMonitor(obj, true);
    }

    @Override
    @Uninterruptible(reason="called during deoptimization")
    public void doRelockObject(Object obj, Object lockData) {
        Target_java_util_concurrent_locks_ReentrantLock lock = SubstrateUtil.cast(lockData, Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_ReentrantLock_Sync lSync = lock.sync;
        Target_java_util_concurrent_locks_AbstractQueuedSynchronizer qSync = SubstrateUtil.cast(lSync, Target_java_util_concurrent_locks_AbstractQueuedSynchronizer.class);
        Target_java_util_concurrent_locks_AbstractOwnableSynchronizer aSync = SubstrateUtil.cast(lSync, Target_java_util_concurrent_locks_AbstractOwnableSynchronizer.class);
        Thread currentThread = Thread.currentThread();
        Thread ownerThread = aSync.exclusiveOwnerThread;
        VMError.guarantee(ownerThread == null || ownerThread == currentThread, "Object that needs re-locking during deoptimization is already locked by another thread");
        int oldState = qSync.state;
        int newState = oldState + 1;
        VMError.guarantee(newState > 0, "Maximum lock count exceeded");
        boolean success = UNSAFE.compareAndSwapInt(qSync, SYNC_STATE_FIELD_OFFSET, oldState, newState);
        VMError.guarantee(success, "Could not re-lock object during deoptimization");
        aSync.exclusiveOwnerThread = currentThread;
    }

    @Override
    public boolean isLockedByCurrentThread(Object obj) {
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isHeldByCurrentThread();
    }

    @Override
    public boolean isLockedByAnyThread(Object obj) {
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isLocked();
    }

    @Override
    public int countThreadLock(IsolateThread vmThread) {
        VMError.guarantee(JavaContinuations.useLoom(), "This method is only supported when continuations are enabled.");
        return lockedMonitors.get(vmThread);
    }

    @Override
    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="This method is a wait implementation.")
    protected void doWait(Object obj, long timeoutMillis) throws InterruptedException {
        ReentrantLock lock = this.ensureLocked(obj);
        AbstractQueuedSynchronizer.ConditionObject condition = this.getOrCreateCondition(lock, true);
        if (timeoutMillis == 0L) {
            condition.await();
        } else {
            condition.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void notify(Object obj, boolean notifyAll) {
        ReentrantLock lock = this.ensureLocked(obj);
        AbstractQueuedSynchronizer.ConditionObject condition = this.getOrCreateCondition(lock, false);
        if (condition != null) {
            if (notifyAll) {
                condition.signalAll();
            } else {
                condition.signal();
            }
        }
    }

    protected ReentrantLock ensureLocked(Object obj) {
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, true);
        if (!lockObject.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
        }
        return lockObject;
    }

    protected static int getMonitorOffset(Object obj) {
        return DynamicHub.fromClass(obj.getClass()).getMonitorOffset();
    }

    protected final ReentrantLock getOrCreateMonitor(Object obj, boolean createIfNotExisting) {
        assert (obj != null);
        int monitorOffset = MultiThreadedMonitorSupport.getMonitorOffset(obj);
        if (monitorOffset != 0) {
            return this.getOrCreateMonitorFromObject(obj, createIfNotExisting, monitorOffset);
        }
        return this.getOrCreateMonitorFromMap(obj, createIfNotExisting);
    }

    protected ReentrantLock getOrCreateMonitorFromObject(Object obj, boolean createIfNotExisting, int monitorOffset) {
        ReentrantLock existingMonitor = KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
        if (existingMonitor != null || !createIfNotExisting) {
            assert (existingMonitor == null || MultiThreadedMonitorSupport.isMonitorLock(existingMonitor));
            return existingMonitor;
        }
        ReentrantLock newMonitor = MultiThreadedMonitorSupport.newMonitorLock();
        if (UNSAFE.compareAndSwapObject(obj, monitorOffset, null, newMonitor)) {
            return newMonitor;
        }
        return KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantLock getOrCreateMonitorFromMap(Object obj, boolean createIfNotExisting) {
        assert (obj.getClass() != Target_java_lang_ref_ReferenceQueue_Lock.class) : "ReferenceQueue.Lock must have a monitor field or we can deadlock accessing WeakIdentityHashMap below";
        VMError.guarantee(!this.additionalMonitorsLock.isHeldByCurrentThread(), "Recursive manipulation of the additionalMonitors map can lead to table corruptions and double insertion of a monitor for the same object");
        this.additionalMonitorsLock.lock();
        try {
            ReentrantLock existingMonitor = this.additionalMonitors.get(obj);
            if (existingMonitor != null || !createIfNotExisting) {
                assert (existingMonitor == null || MultiThreadedMonitorSupport.isMonitorLock(existingMonitor));
                ReentrantLock reentrantLock = existingMonitor;
                return reentrantLock;
            }
            ReentrantLock newMonitor = MultiThreadedMonitorSupport.newMonitorLock();
            ReentrantLock previousEntry = this.additionalMonitors.put(obj, newMonitor);
            VMError.guarantee(previousEntry == null, "Replaced monitor in secondary storage map");
            ReentrantLock reentrantLock = newMonitor;
            return reentrantLock;
        }
        finally {
            this.additionalMonitorsLock.unlock();
        }
    }

    protected static ReentrantLock newMonitorLock() {
        ReentrantLock newMonitor = new ReentrantLock();
        Target_java_util_concurrent_locks_ReentrantLock lock = SubstrateUtil.cast(newMonitor, Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_ReentrantLock_NonfairSync sync = SubstrateUtil.cast(lock.sync, Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class);
        sync.objectMonitorCondition = SubstrateUtil.cast(MONITOR_WITHOUT_CONDITION, Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject.class);
        assert (MultiThreadedMonitorSupport.isMonitorLock(newMonitor));
        return newMonitor;
    }

    protected static ReentrantLock newLockedMonitorForThread(IsolateThread isolateThread, int recursionDepth) {
        ReentrantLock result = MultiThreadedMonitorSupport.newMonitorLock();
        for (int i = 0; i < recursionDepth; ++i) {
            result.lock();
        }
        Target_java_util_concurrent_locks_ReentrantLock lock = SubstrateUtil.cast(result, Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_AbstractOwnableSynchronizer sync = SubstrateUtil.cast(lock.sync, Target_java_util_concurrent_locks_AbstractOwnableSynchronizer.class);
        assert (sync.exclusiveOwnerThread == Thread.currentThread()) : "Must be locked by current thread";
        sync.exclusiveOwnerThread = JavaThreads.fromVMThread(isolateThread);
        return result;
    }

    protected static boolean isMonitorLock(ReentrantLock lock) {
        return lock != null && MultiThreadedMonitorSupport.isMonitorLockSynchronizer(SubstrateUtil.cast((Object)lock, Target_java_util_concurrent_locks_ReentrantLock.class).sync);
    }

    protected static boolean isMonitorLockSynchronizer(Object obj) {
        if (obj != null && obj.getClass() == Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class) {
            Target_java_util_concurrent_locks_ReentrantLock_NonfairSync sync = SubstrateUtil.cast(obj, Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class);
            return sync.objectMonitorCondition != null;
        }
        return false;
    }

    public ReentrantLock getMonitorForTesting(Object obj) {
        return this.getOrCreateMonitor(obj, true);
    }

    protected AbstractQueuedSynchronizer.ConditionObject getOrCreateCondition(ReentrantLock monitorLock, boolean createIfNotExisting) {
        assert (MultiThreadedMonitorSupport.isMonitorLock(monitorLock));
        Target_java_util_concurrent_locks_ReentrantLock lock = SubstrateUtil.cast(monitorLock, Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_ReentrantLock_NonfairSync sync = SubstrateUtil.cast(lock.sync, Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class);
        AbstractQueuedSynchronizer.ConditionObject existingCondition = SubstrateUtil.cast(sync.objectMonitorCondition, AbstractQueuedSynchronizer.ConditionObject.class);
        if (existingCondition == MONITOR_WITHOUT_CONDITION) {
            existingCondition = null;
        }
        if (existingCondition != null || !createIfNotExisting) {
            assert (existingCondition == null || MultiThreadedMonitorSupport.isMonitorCondition(existingCondition));
            return existingCondition;
        }
        AbstractQueuedSynchronizer.ConditionObject newCondition = (AbstractQueuedSynchronizer.ConditionObject)monitorLock.newCondition();
        if (!UNSAFE.compareAndSwapObject(sync, SYNC_MONITOR_CONDITION_FIELD_OFFSET, MONITOR_WITHOUT_CONDITION, newCondition)) {
            newCondition = SubstrateUtil.cast(sync.objectMonitorCondition, AbstractQueuedSynchronizer.ConditionObject.class);
            assert (MultiThreadedMonitorSupport.isMonitorCondition(newCondition)) : "race winner must have installed valid condition";
        }
        return newCondition;
    }

    protected static boolean isMonitorCondition(Object obj) {
        Target_java_util_concurrent_locks_AbstractQueuedSynchronizer enclosing;
        if (obj != null && obj.getClass() == Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject.class && (enclosing = SubstrateUtil.cast((Object)obj, Target_java_util_concurrent_locks_AbstractQueuedSynchronizer_ConditionObject.class).this$0).getClass() == Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class) {
            Target_java_util_concurrent_locks_ReentrantLock_NonfairSync sync = SubstrateUtil.cast(enclosing, Target_java_util_concurrent_locks_ReentrantLock_NonfairSync.class);
            return obj == sync.objectMonitorCondition;
        }
        return false;
    }

    static {
        try {
            HashSet monitorTypes = new HashSet();
            monitorTypes.add(Class.forName("java.lang.ref.ReferenceQueue$Lock"));
            monitorTypes.add(ReferenceQueue.class);
            monitorTypes.add(FileDescriptor.class);
            monitorTypes.add(Object.class);
            monitorTypes.add(Class.forName("com.oracle.svm.core.jdk.SplittableRandomAccessors"));
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                monitorTypes.add(Class.forName("jdk.internal.ref.PhantomCleanable"));
            }
            FORCE_MONITOR_SLOT_TYPES = Collections.unmodifiableSet(monitorTypes);
        }
        catch (ClassNotFoundException e) {
            throw VMError.shouldNotReachHere("Error building the list of types that always need a monitor slot.", e);
        }
        MONITOR_WITHOUT_CONDITION = (AbstractQueuedSynchronizer.ConditionObject)new ReentrantLock().newCondition();
        SYNC_MONITOR_CONDITION_FIELD_OFFSET = -1L;
        SYNC_STATE_FIELD_OFFSET = -1L;
    }
}

