/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.JDK15OrEarlier;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JceSecurityAccessor;
import com.oracle.svm.core.jdk.JceSecurityUtil;
import com.oracle.svm.core.util.VMError;
import java.net.URL;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Map;

@TargetClass(className="javax.crypto.JceSecurity")
final class Target_javax_crypto_JceSecurity {
    @Alias
    @TargetElement(onlyWith={JDK15OrEarlier.class})
    @InjectAccessors(value=JceSecurityAccessor.class)
    static SecureRandom RANDOM;
    @Alias
    private static Object PROVIDER_VERIFIED;
    @Alias
    private static Map<Object, Object> verificationResults;

    Target_javax_crypto_JceSecurity() {
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    static void verifyProviderJar(URL var0) {
        throw JceSecurityUtil.shouldNotReach("javax.crypto.JceSecurity.verifyProviderJar(URL)");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    static void verifyProvider(URL codeBase, Provider p) {
        throw JceSecurityUtil.shouldNotReach("javax.crypto.JceSecurity.verifyProviderJar(URL, Provider)");
    }

    @Substitute
    static URL getCodeBase(Class<?> clazz) {
        throw VMError.unsupportedFeature("Trying to access the code base of " + clazz + ". ");
    }

    @Substitute
    static Exception getVerificationResult(Provider p) {
        Object o = verificationResults.get(JceSecurityUtil.providerKey(p));
        if (o == PROVIDER_VERIFIED) {
            return null;
        }
        if (o != null) {
            return (Exception)o;
        }
        throw VMError.unsupportedFeature("Trying to verify a provider that was not registered at build time: " + p + ". All providers must be registered and verified in the Native Image builder. ");
    }
}

