/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.ImageHeapMap;
import com.oracle.svm.core.util.VMError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Resources {
    private final EconomicMap<String, List<byte[]>> resources = ImageHeapMap.create();

    static Resources singleton() {
        return (Resources)ImageSingletons.lookup(Resources.class);
    }

    Resources() {
    }

    public EconomicMap<String, List<byte[]>> resources() {
        return this.resources;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerResource(String name, InputStream is) {
        byte[] arr = new byte[4096];
        int pos = 0;
        try {
            while (true) {
                int len;
                if (pos == arr.length) {
                    byte[] tmp = new byte[arr.length * 2];
                    System.arraycopy(arr, 0, tmp, 0, arr.length);
                    arr = tmp;
                }
                if ((len = is.read(arr, pos, arr.length - pos)) != -1) {
                    pos += len;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        byte[] res = new byte[pos];
        System.arraycopy(arr, 0, res, 0, pos);
        Resources support = Resources.singleton();
        ArrayList<byte[]> list = (ArrayList<byte[]>)support.resources.get((Object)name);
        if (list == null) {
            list = new ArrayList<byte[]>();
            support.resources.put((Object)name, list);
        }
        list.add(res);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerDirectoryResource(String dir, String content) {
        Resources support = Resources.singleton();
        byte[] arr = content.getBytes();
        ArrayList<byte[]> list = (ArrayList<byte[]>)support.resources.get((Object)dir);
        if (list == null) {
            list = new ArrayList<byte[]>();
            support.resources.put((Object)dir, list);
        }
        list.add(arr);
    }

    public static List<byte[]> get(String name) {
        return (List)Resources.singleton().resources.get((Object)name);
    }

    public static URL createURL(String name, final byte[] resourceBytes) {
        try {
            return new URL("resource", null, -1, name, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    class Conn
                    extends URLConnection {
                        final /* synthetic */ byte[] val$resourceBytes;

                        Conn(URL uRL) {
                            this.val$resourceBytes = (byte[])uRL;
                            super(url);
                        }

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return new ByteArrayInputStream(this.val$resourceBytes);
                        }

                        @Override
                        public long getContentLengthLong() {
                            return this.val$resourceBytes.length;
                        }
                    }
                    return new Conn(u, resourceBytes);
                }
            });
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

