/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.meta.SharedMethod;
import java.lang.reflect.AnnotatedElement;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.util.DirectAnnotationAccess;

public class MethodSafepointInsertionPhase
extends Phase {
    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        if (method.isUninterruptible()) {
            return;
        }
        if (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), CFunction.class) || DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)((Object)method), InvokeCFunctionPointer.class)) {
            return;
        }
        for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
            SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
            graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
        }
    }
}

