/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.jdk.ObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.DynamicHubSupport;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import java.lang.reflect.Array;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.ForeignCallWithExceptionNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;
import sun.misc.Unsafe;

public final class SubstrateObjectCloneSnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor CLONE = SnippetRuntime.findForeignCall(SubstrateObjectCloneSnippets.class, "doClone", true, LocationIdentity.any());
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CLONE};

    public static void registerForeignCalls(Providers providers, SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(providers, FOREIGN_CALLS);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static Object doClone(Object original) throws CloneNotSupportedException, InstantiationException {
        long entryStart;
        int firstFieldOffset;
        if (original == null) {
            throw new NullPointerException();
        }
        if (!(original instanceof Cloneable)) {
            throw new CloneNotSupportedException("Object is no instance of Cloneable.");
        }
        DynamicHub hub = KnownIntrinsics.readHub(original);
        int layoutEncoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isArray(layoutEncoding)) {
            int length = ArrayLengthNode.arrayLength((Object)original);
            Object newArray = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
            if (LayoutEncoding.isObjectArray(layoutEncoding)) {
                JavaMemoryUtil.copyObjectArrayForward(original, 0, newArray, 0, length, layoutEncoding);
            } else {
                JavaMemoryUtil.copyPrimitiveArrayForward(original, 0, newArray, 0, length, layoutEncoding);
            }
            return newArray;
        }
        Unsafe unsafe = GraalUnsafeAccess.getUnsafe();
        Object result = unsafe.allocateInstance(DynamicHub.toClass(hub));
        int curOffset = firstFieldOffset = ConfigurationValues.getObjectLayout().getFirstFieldOffset();
        NonmovableArray<Byte> referenceMapEncoding = DynamicHubSupport.getReferenceMapEncoding();
        int referenceSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int referenceMapIndex = hub.getReferenceMapIndex();
        int entryCount = NonmovableByteArrayReader.getS4(referenceMapEncoding, referenceMapIndex);
        assert (entryCount >= 0);
        for (long idx = entryStart = (long)(referenceMapIndex + 4); idx < entryStart + (long)(entryCount * 8); idx += 8L) {
            int objectOffset = NonmovableByteArrayReader.getS4(referenceMapEncoding, idx);
            long count = NonmovableByteArrayReader.getU4(referenceMapEncoding, idx + 4L);
            assert (objectOffset >= firstFieldOffset) : "must not overwrite the object header";
            int primitiveDataSize = objectOffset - curOffset;
            assert (primitiveDataSize >= 0);
            assert (curOffset >= 0);
            JavaMemoryUtil.copyForward(original, WordFactory.unsigned((int)curOffset), result, WordFactory.unsigned((int)curOffset), WordFactory.unsigned((int)primitiveDataSize));
            assert ((curOffset += primitiveDataSize) >= 0);
            assert (count >= 0L);
            JavaMemoryUtil.copyReferencesForward(original, WordFactory.unsigned((int)curOffset), result, WordFactory.unsigned((int)curOffset), WordFactory.unsigned((long)count));
            curOffset = (int)((long)curOffset + count * (long)referenceSize);
        }
        int objectSize = NumUtil.safeToInt((long)LayoutEncoding.getInstanceSize(layoutEncoding).rawValue());
        int primitiveDataSize = objectSize - curOffset;
        assert (primitiveDataSize >= 0);
        assert (curOffset >= 0);
        JavaMemoryUtil.copyForward(original, WordFactory.unsigned((int)curOffset), result, WordFactory.unsigned((int)curOffset), WordFactory.unsigned((int)primitiveDataSize));
        assert ((curOffset += primitiveDataSize) == objectSize);
        int monitorOffset = hub.getMonitorOffset();
        if (monitorOffset != 0) {
            BarrieredAccess.writeObject((Object)result, (int)monitorOffset, null);
        }
        return result;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object callClone(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Snippet
    public static Object cloneSnippet(Object thisObj) {
        Object result = SubstrateObjectCloneSnippets.callClone(CLONE, thisObj);
        return PiNode.piCastToSnippetReplaceeStamp((Object)result);
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new SubstrateObjectCloneSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private SubstrateObjectCloneSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        ObjectCloneLowering objectCloneLowering = new ObjectCloneLowering();
        lowerings.put(SubstrateObjectCloneNode.class, objectCloneLowering);
        ObjectCloneWithExceptionLowering objectCloneWithExceptionLowering = new ObjectCloneWithExceptionLowering();
        lowerings.put(ObjectCloneWithExceptionNode.class, objectCloneWithExceptionLowering);
    }

    final class ObjectCloneWithExceptionLowering
    implements NodeLoweringProvider<ObjectCloneWithExceptionNode> {
        ObjectCloneWithExceptionLowering() {
        }

        @Override
        public void lower(ObjectCloneWithExceptionNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)CLONE, new ValueNode[]{node.getObject()}));
            call.setBci(node.bci());
            call.setStamp(node.stamp(NodeView.DEFAULT));
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    final class ObjectCloneLowering
    implements NodeLoweringProvider<SubstrateObjectCloneNode> {
        private final SnippetTemplate.SnippetInfo doClone;

        ObjectCloneLowering() {
            this.doClone = SubstrateObjectCloneSnippets.this.snippet(SubstrateObjectCloneSnippets.class, "cloneSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(SubstrateObjectCloneNode node, LoweringTool tool) {
            if (node.graph().getGuardsStage() != StructuredGraph.GuardsStage.AFTER_FSA) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.doClone, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("thisObj", (Object)node.getObject());
            SubstrateObjectCloneSnippets.this.template((ValueNode)node, args).instantiate(SubstrateObjectCloneSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

