/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.code.CompilationResult;

class AdrpLdrMacroInstructionNativeImagePatcher
extends CompilationResult.CodeAnnotation
implements NativeImagePatcher {
    private final AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction;

    AdrpLdrMacroInstructionNativeImagePatcher(AArch64MacroAssembler.AdrpLdrMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void patchCode(int relative, byte[] code) {
        this.macroInstruction.patch(this.macroInstruction.instructionPosition, relative, code);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public int getOffset() {
        throw VMError.unsupportedFeature("trying to get offset of adrp ldr macro instruction");
    }

    @Override
    public int getLength() {
        throw VMError.unsupportedFeature("trying to get length of adrp ldr macro instruction");
    }
}

