/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    private final SerializationParserFunction consumer;

    public SerializationConfigurationParser(SerializationParserFunction consumer) {
        this.consumer = consumer;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        for (Object serializationKey : SerializationConfigurationParser.asList(json, "first level of document must be an array of serialization lists")) {
            Map<String, Object> data = SerializationConfigurationParser.asMap(serializationKey, "second level of document must be serialization descriptor objects ");
            String targetSerializationClass = SerializationConfigurationParser.asString(data.get(NAME_KEY));
            Object optionalCustomCtorValue = data.get(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY);
            String customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
            this.consumer.accept(targetSerializationClass, customTargetConstructorClass);
        }
    }

    @FunctionalInterface
    public static interface SerializationParserFunction {
        public void accept(String var1, String var2);
    }
}

