/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordFactory;

public class CEntryPointSetup {
    public static final Word SINGLE_ISOLATE_SENTINEL = (Word)WordFactory.unsigned((long)0x150150150150150L);
    public static final int SINGLE_ISOLATE_TO_SINGLE_THREAD_ADDEND = 1575;
    public static final Word SINGLE_THREAD_SENTINEL = SINGLE_ISOLATE_SENTINEL.add(1575);

    public static final class LeaveTearDownIsolateEpilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context and to tear down the Isolate.");

        static void leave() {
            int code = CEntryPointActions.leaveTearDownIsolate();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class LeaveDetachThreadEpilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context and to detach the current thread.");

        static void leave() {
            int code = CEntryPointActions.leaveDetachThread();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class LeaveEpilogue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to leave the current IsolateThread context.");

        static void leave() {
            int code = CEntryPointActions.leave();
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterCreateIsolatePrologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to create a new Isolate.");

        public static void enter() {
            int code = CEntryPointActions.enterCreateIsolate((CEntryPointCreateIsolateParameters)WordFactory.nullPointer());
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterIsolatePrologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to enter the provided Isolate in the current thread. The thread might not have been attached to the Isolate first.");

        static void enter(Isolate isolate) {
            int code = CEntryPointActions.enterIsolate(isolate);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    public static final class EnterPrologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to enter the specified IsolateThread context.");

        static void enter(IsolateThread thread) {
            int code = CEntryPointActions.enter(thread);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }
}

