/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.DumpAllStacks;
import com.oracle.svm.core.DumpHeapReport;
import com.oracle.svm.core.DumpRuntimeCompilation;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import java.util.function.BooleanSupplier;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class VMInspection
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return VMInspection.isEnabled() || VMInspectionOptions.DumpThreadStacksOnSignal.getValue() != false;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addStartupHook(() -> {
            DumpAllStacks.install();
            if (VMInspectionOptions.AllowVMInspection.getValue().booleanValue() && !Platform.includedIn(Platform.WINDOWS.class)) {
                DumpHeapReport.install();
                if (DeoptimizationSupport.enabled()) {
                    DumpRuntimeCompilation.install();
                }
            }
        });
    }

    @Fold
    public static boolean isEnabled() {
        return VMInspectionOptions.AllowVMInspection.getValue();
    }

    public static class VMInspectionOptions {
        @Option(help={"Enables features that allow the VM to be inspected during runtime."}, type=OptionType.User)
        public static final HostedOptionKey<Boolean> AllowVMInspection = new HostedOptionKey<Boolean>(false);
        @Option(help={"Dumps all thread stacktraces on SIGQUIT/SIGBREAK."}, type=OptionType.User)
        public static final HostedOptionKey<Boolean> DumpThreadStacksOnSignal = new HostedOptionKey<Boolean>(false);
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return VMInspection.isEnabled();
        }
    }
}

