/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.XOptions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;

public class SubstrateGCOptions {
    @Option(help={"Print summary GC information after each collection"}, type=OptionType.Expert)
    public static final RuntimeOptionKey<Boolean> PrintGC = new RuntimeOptionKey<Boolean>(false);
    @Option(help={"Print more information about the heap before and after each collection"}, type=OptionType.Expert)
    public static final RuntimeOptionKey<Boolean> VerboseGC = new RuntimeOptionKey<Boolean>(false);
    @Option(help={"Determines if references from runtime-compiled code to Java heap objects should be treated as strong or weak."}, type=OptionType.Debug)
    public static final HostedOptionKey<Boolean> TreatRuntimeCodeInfoReferencesAsWeak = new HostedOptionKey<Boolean>(true);
    @Option(help={"Verify the heap before and after each collection."})
    public static final HostedOptionKey<Boolean> VerifyHeap = new HostedOptionKey<Boolean>(false);
    @Option(help={"Ignore calls to System.gc()"}, type=OptionType.Expert)
    public static final RuntimeOptionKey<Boolean> DisableExplicitGC = new RuntimeOptionKey<Boolean>(false);
    @Option(help={"The minimum heap size at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MinHeapSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                XOptions.getXms().setValue(newValue);
            }
        }
    };
    @Option(help={"The maximum heap size at run-time, in bytes."}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MaxHeapSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                XOptions.getXmx().setValue(newValue);
            }
        }
    };
    @Option(help={"The maximum size of the young generation at run-time, in bytes"}, type=OptionType.User)
    public static final RuntimeOptionKey<Long> MaxNewSize = new RuntimeOptionKey<Long>(Long.valueOf(0L)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                XOptions.getXmn().setValue(newValue);
            }
        }
    };
}

