/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.DefaultInvokeTypeFlowUtil;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class DefaultStaticInvokeTypeFlow
extends AbstractStaticInvokeTypeFlow {
    private final boolean isDeoptInvokeTypeFlow;

    DefaultStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        this(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey, false);
    }

    DefaultStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey, boolean isDeoptInvokeTypeFlow) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
        this.isDeoptInvokeTypeFlow = isDeoptInvokeTypeFlow;
    }

    @Override
    protected void onFlowEnabled(PointsToAnalysis bb) {
        bb.postTask(() -> this.update(bb));
    }

    @Override
    public void update(PointsToAnalysis bb) {
        assert (this.isFlowEnabled()) : "The linking should only be triggered for enabled flows: " + String.valueOf(this);
        JVMCIError.guarantee((boolean)LightImmutableCollection.isEmpty(this, CALLEES_ACCESSOR), (String)"Static invoke updated multiple times, source %s, target method %s", (Object[])new Object[]{this.getSource(), this.targetMethod});
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        this.initializeCallees(bb);
        LightImmutableCollection.forEach(this, CALLEES_ACCESSOR, callee -> {
            MethodFlowsGraphInfo calleeFlows = callee.getTypeFlow().getOrCreateMethodFlowsGraphInfo(bb, this);
            this.linkCallee(bb, true, calleeFlows);
        });
    }

    @Override
    public Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(PointsToAnalysis bb) {
        return DefaultInvokeTypeFlowUtil.getAllNonStubCalleesFlows(this);
    }

    @Override
    public boolean isDeoptInvokeTypeFlow() {
        return this.isDeoptInvokeTypeFlow;
    }
}

