/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaField;

public class PointsToAnalysisField
extends AnalysisField {
    private final AtomicReference<StoreFieldTypeFlow.StoreInstanceFieldTypeFlow> contextInsensitiveStore = new AtomicReference();

    PointsToAnalysisField(AnalysisUniverse universe, ResolvedJavaField wrapped) {
        super(universe, wrapped);
    }

    public StoreFieldTypeFlow initAndGetContextInsensitiveStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        return AtomicUtils.produceAndSetValue(this.contextInsensitiveStore, () -> this.createContextInsensitiveStore(bb, originalLocation), t -> PointsToAnalysisField.initContextInsensitiveStore(bb, t));
    }

    private StoreFieldTypeFlow.StoreInstanceFieldTypeFlow createContextInsensitiveStore(PointsToAnalysis bb, BytecodePosition originalLocation) {
        TypeFlow<?> objectFlow = this.declaringClass.getTypeFlow(bb, false);
        StoreFieldTypeFlow.StoreInstanceFieldTypeFlow store = new StoreFieldTypeFlow.StoreInstanceFieldTypeFlow(originalLocation, this, objectFlow);
        store.markAsContextInsensitive();
        store.enableFlow(bb);
        return store;
    }

    private static void initContextInsensitiveStore(PointsToAnalysis bb, StoreFieldTypeFlow.StoreInstanceFieldTypeFlow store) {
        store.receiver().addObserver(bb, store);
    }

    @Override
    public void cleanupAfterAnalysis() {
        super.cleanupAfterAnalysis();
        this.contextInsensitiveStore.set(null);
    }

    @Override
    public boolean registerAsUnsafeAccessed(Object reason) {
        if (super.registerAsUnsafeAccessed(reason)) {
            if (this.fieldType.getStorageKind().isPrimitive()) {
                this.saturatePrimitiveField();
            }
            ((PointsToAnalysis)this.getUniverse().getBigbang()).forceUnsafeUpdate(this);
            return true;
        }
        return false;
    }

    public void saturatePrimitiveField() {
        assert (this.fieldType.isPrimitive() || this.fieldType.isWordType()) : this;
        PointsToAnalysis bb = (PointsToAnalysis)this.getUniverse().getBigbang();
        this.initialFlow.addState(bb, TypeState.anyPrimitiveState());
        this.sinkFlow.addState(bb, TypeState.anyPrimitiveState());
    }
}

