/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ConstantContextSensitiveObject;
import com.oracle.graal.pointsto.heap.TypeData;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.BaseLayerMethod;
import com.oracle.graal.pointsto.meta.BaseLayerType;
import com.oracle.graal.pointsto.meta.ObjectReachableCallback;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashMap;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.LogUtils;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisType
extends AnalysisElement
implements WrappedJavaType,
OriginalClassProvider,
Comparable<AnalysisType> {
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> UNSAFE_ACCESS_FIELDS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "unsafeAccessedFields");
    private static final AtomicReferenceFieldUpdater<AnalysisType, AnalysisObject> UNIQUE_CONSTANT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, AnalysisObject.class, "uniqueConstant");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> INTERCEPTORS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "interceptors");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> subtypeReachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "subtypeReachableNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> instantiatedNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "typeInstantiatedNotifications");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> objectReachableCallbacksUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "objectReachableCallbacks");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isInstantiatedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isInstantiated");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isUnsafeAllocatedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isUnsafeAllocated");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> isReachableUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "isReachable");
    private static final AtomicIntegerFieldUpdater<AnalysisType> isAnySubtypeInstantiatedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisType.class, "isAnySubtypeInstantiated");
    static final AtomicReferenceFieldUpdater<AnalysisType, Object> overrideableMethodsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "overrideableMethods");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> SUBTYPES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "subTypes");
    private static final AtomicReferenceFieldUpdater<AnalysisType, Object> RESOLVED_METHODS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, Object.class, "resolvedMethods");
    public static final AnalysisType[] EMPTY_ARRAY = new AnalysisType[0];
    protected final AnalysisUniverse universe;
    private final ResolvedJavaType wrapped;
    private final String qualifiedName;
    private final String unqualifiedName;
    private volatile Object isInstantiated;
    private volatile Object isUnsafeAllocated;
    private volatile Object isReachable;
    private volatile int isAnySubtypeInstantiated;
    private boolean reachabilityListenerNotified;
    private boolean unsafeFieldsRecomputed;
    private volatile Object unsafeAccessedFields;
    private volatile Object subTypes;
    AnalysisType superClass;
    private final int id;
    private final boolean isInBaseLayer;
    private final JavaKind storageKind;
    private final boolean isCloneableWithAllocation;
    private AnalysisObject contextInsensitiveAnalysisObject;
    private ConcurrentMap<JavaConstant, AnalysisObject> constantObjectsCache;
    private volatile AnalysisObject uniqueConstant;
    private volatile Object resolvedMethods;
    private static final Object NULL_METHOD = new Object();
    private final AnalysisType componentType;
    private final AnalysisType elementalType;
    private final AnalysisType[] interfaces;
    private AnalysisMethod[] declaredMethods;
    private Set<AnalysisMethod> dispatchTableMethods;
    private AnalysisType[] allInterfaces;
    private final boolean isArray;
    private final boolean isJavaLangObject;
    private final int dimension;
    private volatile Object interceptors;
    private final AnalysisFuture<Void> onTypeReachableTask;
    private final AnalysisFuture<Void> initializeMetaDataTask;
    private final AnalysisFuture<TypeData> typeData;
    private volatile Object subtypeReachableNotifications;
    List<AnalysisFuture<Void>> scheduledTypeReachableNotifications;
    private volatile Object typeInstantiatedNotifications;
    private volatile Object objectReachableCallbacks;
    private volatile Object overrideableMethods;
    public TypeState assignableTypesState = TypeState.forNull();
    public TypeState assignableTypesNonNullState = TypeState.forEmpty();
    public AllInstantiatedTypeFlow instantiatedTypes;
    public AllInstantiatedTypeFlow instantiatedTypesNonNull;
    private volatile AnalysisType arrayClass = null;
    private volatile ResolvedJavaField[] instanceFieldsWithSuper;
    private volatile ResolvedJavaField[] instanceFieldsWithoutSuper;
    static final Comparator<ResolvedJavaField> FIELD_COMPARATOR = Comparator.comparing(JavaField::getName).thenComparing(f -> f.getType().toJavaName());
    private static final int ANNOTATION = 8192;

    public AnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType, AnalysisType cloneableType) {
        super(universe.hostVM.enableTrackAcrossLayers());
        this.universe = universe;
        this.wrapped = javaType;
        this.qualifiedName = this.wrapped.toJavaName(true);
        this.unqualifiedName = this.wrapped.toJavaName(false);
        this.isArray = this.wrapped.isArray();
        this.isJavaLangObject = this.wrapped.isJavaLangObject();
        this.storageKind = storageKind;
        if (!this.isPrimitive() && !this.isWordType()) {
            this.instantiatedTypes = new AllInstantiatedTypeFlow(this, true);
            this.instantiatedTypesNonNull = new AllInstantiatedTypeFlow(this, false);
        }
        if (universe.analysisPolicy().needsConstantCache()) {
            this.constantObjectsCache = new ConcurrentHashMap<JavaConstant, AnalysisObject>();
        }
        try {
            this.link();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.superClass = universe.lookup((JavaType)this.wrapped.getSuperclass());
        this.interfaces = this.convertTypes(this.wrapped.getInterfaces());
        if (this.isArray()) {
            this.componentType = universe.lookup((JavaType)this.wrapped.getComponentType());
            int dim = 0;
            AnalysisType elemType = this;
            while (elemType.isArray()) {
                elemType = elemType.getComponentType();
                ++dim;
            }
            if (elemType.getSuperclass() != null) {
                elemType.getSuperclass().getArrayClass(dim);
            }
            this.elementalType = elemType;
            if (dim >= 2) {
                objectType.getArrayClass(dim - 1);
            }
            for (AnalysisType interf : elemType.getInterfaces()) {
                interf.getArrayClass(dim);
            }
            this.dimension = dim;
        } else {
            this.componentType = null;
            this.elementalType = this;
            this.dimension = 0;
        }
        if (universe.hostVM().useBaseLayer()) {
            int tid = universe.getImageLayerLoader().lookupHostedTypeInBaseLayer(this);
            if (tid != -1) {
                this.id = tid;
                this.isInBaseLayer = true;
            } else {
                this.id = universe.computeNextTypeId();
                this.isInBaseLayer = this.wrapped instanceof BaseLayerType;
            }
        } else {
            this.id = universe.computeNextTypeId();
            this.isInBaseLayer = false;
        }
        this.addSubType(this);
        if (this.superClass != null) {
            this.superClass.addSubType(this);
        }
        if (this.isInterface() && this.interfaces.length == 0) {
            objectType.addSubType(this);
        }
        for (AnalysisType interf : this.interfaces) {
            interf.addSubType(this);
        }
        this.contextInsensitiveAnalysisObject = new AnalysisObject(universe, this);
        assert (this.getSuperclass() == null || this.getId() > this.getSuperclass().getId());
        this.isCloneableWithAllocation = this.isJavaLangObject() || this.isInterface() ? false : cloneableType.isAssignableFrom(this);
        this.onTypeReachableTask = new AnalysisFuture<Object>(() -> universe.onTypeReachable(this), null);
        this.initializeMetaDataTask = new AnalysisFuture<Object>(() -> universe.initializeMetaData(this), null);
        this.typeData = new AnalysisFuture<TypeData>(() -> {
            AnalysisError.guarantee(universe.getHeapScanner() != null, "Heap scanner is not available.", new Object[0]);
            return universe.getHeapScanner().computeTypeData(this);
        });
    }

    private AnalysisType[] convertTypes(ResolvedJavaType[] originalTypes) {
        ArrayList<AnalysisType> result = new ArrayList<AnalysisType>(originalTypes.length);
        for (ResolvedJavaType originalType : originalTypes) {
            if (this.universe.hostVM.skipInterface(this.universe, originalType, this.wrapped)) continue;
            result.add(this.universe.lookup((JavaType)originalType));
        }
        return result.toArray(EMPTY_ARRAY);
    }

    public AnalysisType getArrayClass(int dim) {
        AnalysisType result = this;
        for (int i = 0; i < dim; ++i) {
            result = result.getArrayClass();
        }
        return result;
    }

    public int getArrayDimension() {
        return this.dimension;
    }

    public AnalysisType[] getAllInterfaces() {
        if (this.allInterfaces != null) {
            return this.allInterfaces;
        }
        HashSet<AnalysisType> allInterfaceSet = new HashSet<AnalysisType>();
        if (this.isInterface()) {
            allInterfaceSet.add(this);
        }
        if (this.superClass != null) {
            allInterfaceSet.addAll(Arrays.asList(this.superClass.getAllInterfaces()));
        }
        for (AnalysisType i : this.interfaces) {
            allInterfaceSet.addAll(Arrays.asList(i.getAllInterfaces()));
        }
        AnalysisType[] result = (AnalysisType[])allInterfaceSet.toArray(AnalysisType[]::new);
        VarHandle.storeStoreFence();
        this.allInterfaces = result;
        return this.allInterfaces;
    }

    public void cleanupAfterAnalysis() {
        this.instantiatedTypes = null;
        this.instantiatedTypesNonNull = null;
        this.assignableTypesState = null;
        this.assignableTypesNonNullState = null;
        this.contextInsensitiveAnalysisObject = null;
        this.constantObjectsCache = null;
        this.uniqueConstant = null;
        this.unsafeAccessedFields = null;
        this.scheduledTypeReachableNotifications = null;
    }

    public int getId() {
        return this.id;
    }

    public boolean isInBaseLayer() {
        return this.isInBaseLayer;
    }

    public AnalysisObject getContextInsensitiveAnalysisObject() {
        return this.contextInsensitiveAnalysisObject;
    }

    public AnalysisObject getUniqueConstantObject() {
        return this.uniqueConstant;
    }

    public AnalysisObject getCachedConstantObject(PointsToAnalysis bb, JavaConstant constant, Function<JavaConstant, AnalysisObject> constantTransformer) {
        assert (bb.analysisPolicy().needsConstantCache()) : "The analysis policy doesn't specify the need for a constants cache.";
        assert (bb.trackConcreteAnalysisObjects(this)) : this;
        assert (!(constant instanceof PrimitiveConstant)) : "The analysis should not model PrimitiveConstant.";
        if (this.uniqueConstant != null) {
            return this.uniqueConstant;
        }
        if (bb.maxConstantObjectsPerType() > 0 && this.constantObjectsCache.size() >= bb.maxConstantObjectsPerType()) {
            this.mergeConstantObjects(bb);
            return this.uniqueConstant;
        }
        return this.constantObjectsCache.computeIfAbsent(constant, constantTransformer);
    }

    private void mergeConstantObjects(PointsToAnalysis bb) {
        ConstantContextSensitiveObject uConstant = new ConstantContextSensitiveObject(bb, this);
        if (UNIQUE_CONSTANT_UPDATER.compareAndSet(this, null, uConstant)) {
            this.constantObjectsCache.values().forEach(constantObject -> {
                if (constantObject instanceof ConstantContextSensitiveObject) {
                    ConstantContextSensitiveObject ct = (ConstantContextSensitiveObject)constantObject;
                    ct.setMergedWithUniqueConstantObject();
                    ct.mergeInstanceFieldsFlows(bb, this.uniqueConstant);
                }
            });
        }
    }

    public TypeFlow<?> getTypeFlow(BigBang bb, boolean includeNull) {
        if (this.isPrimitive() || this.isWordType()) {
            return ((PointsToAnalysis)bb).getAnyPrimitiveSourceTypeFlow();
        }
        if (includeNull) {
            return this.instantiatedTypes;
        }
        return this.instantiatedTypesNonNull;
    }

    public TypeState getAssignableTypes(boolean includeNull) {
        if (includeNull) {
            return this.assignableTypesState;
        }
        return this.assignableTypesNonNullState;
    }

    public static boolean verifyAssignableTypes(BigBang bb) {
        List<AnalysisType> allTypes = bb.getUniverse().getTypes();
        ConcurrentHashMap.KeySetView mismatchedAssignableResults = ConcurrentHashMap.newKeySet();
        allTypes.parallelStream().filter(t -> t.instantiatedTypes != null).forEach(t1 -> {
            for (AnalysisType t2 : allTypes) {
                boolean expected = t2.isInstantiated() ? t1.isAssignableFrom(t2) : false;
                boolean actual = t1.instantiatedTypes.getState().containsType(t2);
                if (actual == expected) continue;
                mismatchedAssignableResults.add("assignableTypes mismatch: " + t1.toJavaName(true) + " (instantiated: " + t1.isInstantiated() + ") - " + t2.toJavaName(true) + " (instantiated: " + t2.isInstantiated() + "): expected=" + expected + ", actual=" + actual);
            }
        });
        if (!mismatchedAssignableResults.isEmpty()) {
            mismatchedAssignableResults.forEach(System.err::println);
            throw new AssertionError((Object)"Verification of all-instantiated type flows failed");
        }
        return true;
    }

    public boolean registerAsInstantiated(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a type as instantiated needs to provide a valid reason.";
        this.registerAsReachable(reason);
        if (AtomicUtils.atomicSet(this, reason, isInstantiatedUpdater)) {
            this.onInstantiated();
            return true;
        }
        return false;
    }

    protected void onInstantiated() {
        assert (!this.isWordType()) : Assertions.errorMessage((Object[])new Object[]{"Word types cannot be instantiated", this});
        this.forAllSuperTypes(superType -> AtomicUtils.atomicMark(superType, isAnySubtypeInstantiatedUpdater));
        this.universe.onTypeInstantiated(this);
        this.notifyInstantiatedCallbacks();
    }

    public boolean registerAsUnsafeAllocated(Object reason) {
        this.registerAsInstantiated(reason);
        return AtomicUtils.atomicSet(this, reason, isUnsafeAllocatedUpdater);
    }

    public void registerAsAssignable(BigBang bb) {
    }

    public boolean registerAsReachable(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a type as reachable needs to provide a valid reason.";
        if (!AtomicUtils.isSet(this, isReachableUpdater)) {
            this.forAllSuperTypes(type -> type.registerAsReachable(reason), false);
            AtomicUtils.atomicSetAndRun(this, reason, isReachableUpdater, () -> this.onReachable(reason));
            return true;
        }
        return false;
    }

    @Override
    protected void onReachable(Object reason) {
        this.registerAsTrackedAcrossLayers(reason);
        ArrayList<AnalysisFuture<Void>> futures = new ArrayList<AnalysisFuture<Void>>();
        this.notifyReachabilityCallbacks(this.universe, futures);
        this.forAllSuperTypes(type -> ConcurrentLightHashSet.forEach(type, subtypeReachableNotificationsUpdater, n -> futures.add(n.notifyCallback(this.universe, this))));
        if (futures.size() > 0) {
            this.scheduledTypeReachableNotifications = futures;
        }
        if (this.isInBaseLayer && !(this.wrapped instanceof BaseLayerType)) {
            this.getInstanceFields(true);
            this.getStaticFields();
        }
        this.universe.notifyReachableType();
        if (this.isArray()) {
            this.registerAsInstantiated("All array types are marked as instantiated eagerly.");
        }
        this.universe.getBigbang().postTask(unused -> this.forAllSuperTypes(this::prepareMethodImplementations, false));
        this.ensureOnTypeReachableTaskDone();
    }

    @Override
    protected void onTrackedAcrossLayers(Object reason) {
        AnalysisError.guarantee(!this.getUniverse().sealed(), "Type %s was marked as tracked after the universe was sealed", this);
        if (this.superClass != null) {
            this.superClass.registerAsTrackedAcrossLayers(reason);
        }
        for (AnalysisType inter : this.interfaces) {
            inter.registerAsTrackedAcrossLayers(reason);
        }
        try {
            AnalysisType enclosingType = this.getEnclosingType();
            if (enclosingType != null) {
                enclosingType.registerAsTrackedAcrossLayers(reason);
            }
        }
        catch (InternalError | LinkageError | TypeNotPresentException throwable) {
            // empty catch block
        }
    }

    private void prepareMethodImplementations(AnalysisType superType) {
        ConcurrentLightHashSet.forEach(superType, overrideableMethodsUpdater, method -> {
            assert (!method.canBeStaticallyBound() && !method.isConstructor()) : method;
            AnalysisMethod override = this.resolveConcreteMethod((ResolvedJavaMethod)method, null);
            if (override != null && !override.equals(method)) {
                ConcurrentLightHashSet.addElement(method, AnalysisMethod.allImplementationsUpdater, override);
                if (method.reachableInCurrentLayer()) {
                    override.setReachableInCurrentLayer();
                }
            }
        });
    }

    public void registerSubtypeReachabilityNotification(AnalysisElement.SubtypeReachableNotification notification) {
        ConcurrentLightHashSet.addElement(this, subtypeReachableNotificationsUpdater, notification);
    }

    public <T> void registerObjectReachableCallback(ObjectReachableCallback<T> callback) {
        ConcurrentLightHashSet.addElement(this, objectReachableCallbacksUpdater, callback);
        ConcurrentLightHashSet.forEach(this, SUBTYPES_UPDATER, subType -> {
            if (!subType.equals(this)) {
                subType.registerObjectReachableCallback(callback);
            }
        });
    }

    public <T> void notifyObjectReachable(T object, ObjectScanner.ScanReason reason) {
        ConcurrentLightHashSet.forEach(this, objectReachableCallbacksUpdater, c -> c.doCallback(this.universe.getConcurrentAnalysisAccess(), object, reason));
    }

    public void registerInstantiatedCallback(Consumer<Feature.DuringAnalysisAccess> callback) {
        if (this.isInstantiated()) {
            callback.accept(this.universe.getConcurrentAnalysisAccess());
        } else {
            AnalysisElement.ElementNotification notification = new AnalysisElement.ElementNotification(callback);
            ConcurrentLightHashSet.addElement(this, instantiatedNotificationsUpdater, notification);
            if (this.isInstantiated()) {
                this.notifyInstantiatedCallback(notification);
            }
        }
    }

    private void notifyInstantiatedCallback(AnalysisElement.ElementNotification notification) {
        notification.notifyCallback(this.universe, this);
        ConcurrentLightHashSet.removeElement(this, instantiatedNotificationsUpdater, notification);
    }

    protected void notifyInstantiatedCallbacks() {
        ConcurrentLightHashSet.forEach(this, instantiatedNotificationsUpdater, c -> c.notifyCallback(this.universe, this));
        ConcurrentLightHashSet.removeElementIf(this, instantiatedNotificationsUpdater, AnalysisElement.ElementNotification::isNotified);
    }

    public void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer) {
        this.forAllSuperTypes(superTypeConsumer, true);
    }

    protected void forAllSuperTypes(Consumer<AnalysisType> superTypeConsumer, boolean includeThisType) {
        AnalysisType.forAllSuperTypes(this.elementalType, this.dimension, includeThisType, superTypeConsumer);
        for (int i = 0; i < this.dimension; ++i) {
            AnalysisType.forAllSuperTypes(this, i, false, superTypeConsumer);
        }
        if (this.dimension > 0 && !this.elementalType.isPrimitive() && !this.elementalType.isJavaLangObject()) {
            AnalysisType.forAllSuperTypes(this.universe.objectType(), this.dimension, true, superTypeConsumer);
        }
        if (this.isInterface()) {
            superTypeConsumer.accept(this.universe.objectType());
        }
    }

    private static void forAllSuperTypes(AnalysisType elementType, int arrayDimension, boolean processType, Consumer<AnalysisType> superTypeConsumer) {
        if (elementType == null) {
            return;
        }
        if (processType) {
            superTypeConsumer.accept(elementType.getArrayClass(arrayDimension));
        }
        for (AnalysisType interf : elementType.getInterfaces()) {
            AnalysisType.forAllSuperTypes(interf, arrayDimension, true, superTypeConsumer);
        }
        AnalysisType.forAllSuperTypes(elementType.getSuperclass(), arrayDimension, true, superTypeConsumer);
    }

    protected synchronized void addAssignableType(BigBang bb, TypeState typeState) {
        this.assignableTypesState = TypeState.forUnion((PointsToAnalysis)bb, this.assignableTypesState, typeState);
        this.assignableTypesNonNullState = this.assignableTypesState.forNonNull((PointsToAnalysis)bb);
    }

    public TypeData getOrComputeData() {
        GraalError.guarantee((boolean)this.isReachable(), (String)"TypeData is only available for reachable types");
        return this.typeData.ensureDone();
    }

    public void ensureOnTypeReachableTaskDone() {
        this.onTypeReachableTask.ensureDone();
    }

    public AnalysisFuture<Void> getInitializeMetaDataTask() {
        return this.initializeMetaDataTask;
    }

    public boolean getReachabilityListenerNotified() {
        return this.reachabilityListenerNotified;
    }

    public void setReachabilityListenerNotified(boolean reachabilityListenerNotified) {
        this.reachabilityListenerNotified = reachabilityListenerNotified;
    }

    public void registerUnsafeFieldsRecomputed() {
        this.unsafeFieldsRecomputed = true;
    }

    public void registerUnsafeAccessedField(AnalysisField field) {
        AnalysisError.guarantee(!this.universe.analysisPolicy().useConservativeUnsafeAccess(), "With conservative unsafe access we don't track unsafe accessed fields.", new Object[0]);
        ConcurrentLightHashSet.addElement(this, UNSAFE_ACCESS_FIELDS_UPDATER, field);
    }

    public Collection<AnalysisField> unsafeAccessedFields() {
        AnalysisError.guarantee(!this.universe.analysisPolicy().useConservativeUnsafeAccess(), "With conservative unsafe access we don't track unsafe accessed fields.", new Object[0]);
        Collection result = null;
        for (AnalysisType cur = this; cur != null; cur = cur.getSuperclass()) {
            Collection curFields = ConcurrentLightHashSet.getElements(cur, UNSAFE_ACCESS_FIELDS_UPDATER);
            if (curFields.size() <= 0) continue;
            if (result == null) {
                result = curFields;
                continue;
            }
            if (!(result instanceof ArrayList)) {
                result = new ArrayList(result);
            }
            result.addAll(curFields);
        }
        return result == null ? List.of() : result;
    }

    public boolean isInstantiated() {
        boolean instantiated = AtomicUtils.isSet(this, isInstantiatedUpdater);
        assert (!instantiated || this.isReachable()) : this;
        return instantiated;
    }

    public Object getInstantiatedReason() {
        return this.isInstantiated;
    }

    public boolean isUnsafeAllocated() {
        return AtomicUtils.isSet(this, isUnsafeAllocatedUpdater);
    }

    public boolean isAnySubtypeInstantiated() {
        return AtomicUtils.isSet(this, isAnySubtypeInstantiatedUpdater);
    }

    public boolean unsafeFieldsRecomputed() {
        return this.unsafeFieldsRecomputed;
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isReachableUpdater);
    }

    public Object getReachableReason() {
        return this.isReachable;
    }

    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public boolean isWordType() {
        boolean wordType;
        boolean bl = wordType = this.getJavaKind() != this.getStorageKind();
        assert (!wordType || this.getJavaKind().isObject()) : Assertions.errorMessage((Object[])new Object[]{"Only words are expected to have a discrepancy between java kind and storage kind", this});
        return wordType;
    }

    @Override
    public ResolvedJavaType getWrapped() {
        return this.wrapped;
    }

    @Override
    public ResolvedJavaType unwrapTowardsOriginalType() {
        return this.wrapped;
    }

    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass((JavaType)this);
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public String toJavaName() {
        return this.qualifiedName;
    }

    public String toJavaName(boolean qualified) {
        return qualified ? this.qualifiedName : this.unqualifiedName;
    }

    public final JavaKind getJavaKind() {
        return this.wrapped.getJavaKind();
    }

    public final ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.universe.hostVM.isInitialized(this);
    }

    public void initialize() {
        if (!this.wrapped.isInitialized()) {
            throw GraalError.shouldNotReachHere((String)("Classes can only be initialized using methods in ClassInitializationFeature: " + this.toClassName()));
        }
    }

    public final AnalysisType getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = this.universe.lookup((JavaType)this.wrapped.getArrayClass());
        }
        return this.arrayClass;
    }

    public boolean isInterface() {
        return this.wrapped.isInterface();
    }

    public boolean isEnum() {
        return this.wrapped.isEnum();
    }

    public boolean isInstanceClass() {
        return this.wrapped.isInstanceClass();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isJavaLangObject() {
        return this.isJavaLangObject;
    }

    public boolean isPrimitive() {
        return this.wrapped.isPrimitive();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return this.wrapped.isAssignableFrom(OriginalClassProvider.getOriginalType((JavaType)other));
    }

    public boolean isInstance(JavaConstant obj) {
        return this.wrapped.isInstance(obj);
    }

    public AnalysisType getSuperclass() {
        return this.superClass;
    }

    public AnalysisType[] getInterfaces() {
        return this.interfaces;
    }

    public ResolvedJavaType getSingleImplementor() {
        return this;
    }

    public Collection<AnalysisType> getSubTypes() {
        return ConcurrentLightHashSet.getElements(this, SUBTYPES_UPDATER);
    }

    private void addSubType(AnalysisType subType) {
        boolean result = ConcurrentLightHashSet.addElement(this, SUBTYPES_UPDATER, subType);
        if (!subType.equals(this)) {
            ConcurrentLightHashSet.forEach(this, objectReachableCallbacksUpdater, callback -> subType.registerObjectReachableCallback((ObjectReachableCallback)callback));
        }
        assert (result) : "Tried to add a " + String.valueOf(subType) + " which is already registered";
    }

    public Set<AnalysisType> getAllSubtypes() {
        HashSet<AnalysisType> result = new HashSet<AnalysisType>();
        AnalysisType.collectSubtypes(this, result);
        return result;
    }

    private static void collectSubtypes(AnalysisType baseType, Set<AnalysisType> result) {
        for (AnalysisType subType : baseType.getSubTypes()) {
            if (!result.add(subType)) continue;
            AnalysisType.collectSubtypes(subType, result);
        }
    }

    public AnalysisType findLeastCommonAncestor(ResolvedJavaType otherType) {
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor(OriginalClassProvider.getOriginalType((JavaType)otherType)));
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        Assumptions.AssumptionResult wrappedResult = this.wrapped.findLeafConcreteSubtype();
        if (wrappedResult != null && wrappedResult.isAssumptionFree()) {
            return new Assumptions.AssumptionResult((Object)this.universe.lookup((JavaType)wrappedResult.getResult()));
        }
        return null;
    }

    public AnalysisType getComponentType() {
        return this.componentType;
    }

    public AnalysisType getElementalType() {
        return this.elementalType;
    }

    public boolean hasSubTypes() {
        return ConcurrentLightHashSet.size(this, SUBTYPES_UPDATER) > 1;
    }

    public AnalysisMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw GraalError.unimplementedOverride();
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        Object resolvedMethod = ConcurrentLightHashMap.get(this, RESOLVED_METHODS_UPDATER, method);
        if (resolvedMethod == null) {
            Object oldResolvedMethod;
            ResolvedJavaMethod originalMethod = OriginalMethodProvider.getOriginalMethod(method);
            Object newResolvedMethod = null;
            if (originalMethod != null) {
                ResolvedJavaType originalCallerType = originalMethod.getDeclaringClass();
                try {
                    ResolvedJavaMethod concreteMethod = originalMethod instanceof BaseLayerMethod ? originalMethod : this.wrapped.resolveConcreteMethod(originalMethod, originalCallerType);
                    newResolvedMethod = this.universe.lookup((JavaMethod)concreteMethod);
                    if (newResolvedMethod == null) {
                        newResolvedMethod = this.getUniverse().getBigbang().fallbackResolveConcreteMethod(this, (AnalysisMethod)method);
                    }
                }
                catch (UnsupportedFeatureException e) {
                    newResolvedMethod = null;
                }
            }
            if (newResolvedMethod == null) {
                newResolvedMethod = NULL_METHOD;
            }
            resolvedMethod = (oldResolvedMethod = ConcurrentLightHashMap.putIfAbsent(this, RESOLVED_METHODS_UPDATER, method, newResolvedMethod)) != null ? oldResolvedMethod : newResolvedMethod;
        }
        return resolvedMethod == NULL_METHOD ? null : (AnalysisMethod)resolvedMethod;
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method) {
        return this.resolveConcreteMethod(method, null);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.universe.lookup((JavaField)this.wrapped.findInstanceFieldWithOffset(offset, expectedKind));
    }

    public void clearInstanceFieldsCache() {
        this.instanceFieldsWithSuper = null;
        this.instanceFieldsWithoutSuper = null;
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        ResolvedJavaField[] result;
        ResolvedJavaField[] resolvedJavaFieldArray = result = includeSuperclasses ? this.instanceFieldsWithSuper : this.instanceFieldsWithoutSuper;
        if (result != null) {
            return result;
        }
        return this.initializeInstanceFields(includeSuperclasses);
    }

    private ResolvedJavaField[] initializeInstanceFields(boolean includeSuperclasses) {
        ArrayList<ResolvedJavaField> list = new ArrayList<ResolvedJavaField>();
        if (includeSuperclasses && this.getSuperclass() != null) {
            list.addAll(Arrays.asList(this.getSuperclass().getInstanceFields(true)));
        }
        ResolvedJavaField[] result = this.convertFields(this.interceptInstanceFields(this.wrapped.getInstanceFields(false)), list, includeSuperclasses);
        if (includeSuperclasses) {
            this.instanceFieldsWithSuper = result;
        } else {
            this.instanceFieldsWithoutSuper = result;
        }
        return result;
    }

    private ResolvedJavaField[] convertFields(ResolvedJavaField[] originals, List<ResolvedJavaField> list, boolean listIncludesSuperClassesFields) {
        ResolvedJavaField[] localOriginals = originals;
        if (this.universe.hostVM.sortFields()) {
            localOriginals = (ResolvedJavaField[])originals.clone();
            Arrays.sort(localOriginals, FIELD_COMPARATOR);
        }
        for (ResolvedJavaField original : localOriginals) {
            if (original.isInternal() || !this.universe.hostVM.platformSupported((AnnotatedElement)original)) continue;
            try {
                AnalysisField aField = this.universe.lookup((JavaField)original);
                if (aField == null) continue;
                if (listIncludesSuperClassesFields || aField.isStatic()) {
                    aField.setPosition(list.size());
                }
                list.add(aField);
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                // empty catch block
            }
        }
        return list.toArray(new ResolvedJavaField[list.size()]);
    }

    public ResolvedJavaField[] getStaticFields() {
        return this.convertFields(this.wrapped.getStaticFields(), new ArrayList<ResolvedJavaField>(), false);
    }

    public String getSourceFileName() {
        return this.wrapped.isPrimitive() ? null : this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "AnalysisType<" + this.unqualifiedName + " -> " + this.wrapped.toString() + ", instantiated: " + (this.isInstantiated != null) + ", reachable: " + (this.isReachable != null) + ">";
    }

    public boolean isLocal() {
        try {
            return this.wrapped.isLocal();
        }
        catch (InternalError e) {
            LogUtils.warning((String)("Unknown locality of class " + this.wrapped.getName() + ", assuming class is not local. To remove the warning report an issue to the library or language author. The issue is caused by " + this.wrapped.getName() + " which is not following the naming convention."));
            return false;
        }
    }

    public boolean isMember() {
        return this.wrapped.isMember();
    }

    public AnalysisType getEnclosingType() {
        return this.universe.lookup((JavaType)this.wrapped.getEnclosingType());
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        return this.getDeclaredMethods(true);
    }

    public AnalysisMethod[] getDeclaredMethods(boolean forceLink) {
        GraalError.guarantee((!forceLink ? 1 : 0) != 0, (String)"only use getDeclaredMethods without forcing to link, because linking can throw LinkageError");
        AnalysisMethod[] result = this.declaredMethods;
        if (result == null) {
            result = this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods(forceLink));
            VarHandle.storeStoreFence();
            this.declaredMethods = result;
        }
        return result;
    }

    public List<ResolvedJavaMethod> getAllMethods(boolean forceLink) {
        throw GraalError.unimplementedOverride();
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        return this.getDeclaredConstructors(true);
    }

    public AnalysisMethod[] getDeclaredConstructors(boolean forceLink) {
        GraalError.guarantee((!forceLink ? 1 : 0) != 0, (String)"only use getDeclaredConstructors without forcing to link, because linking can throw LinkageError");
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors(forceLink));
    }

    public AnalysisMethod findConstructor(Signature signature) {
        if (this.wrapped instanceof BaseLayerType) {
            return null;
        }
        for (AnalysisMethod ctor : this.getDeclaredConstructors(false)) {
            if (!ctor.getSignature().equals(signature)) continue;
            return ctor;
        }
        return null;
    }

    public boolean isOpenTypeWorldDispatchTableMethodsCalculated() {
        return this.dispatchTableMethods != null;
    }

    public Set<AnalysisMethod> getOpenTypeWorldDispatchTableMethods() {
        Objects.requireNonNull(this.dispatchTableMethods);
        return this.dispatchTableMethods;
    }

    public Set<AnalysisMethod> getOrCalculateOpenTypeWorldDispatchTableMethods() {
        if (this.dispatchTableMethods != null) {
            return this.dispatchTableMethods;
        }
        if (this.isPrimitive()) {
            this.dispatchTableMethods = Set.of();
            return this.dispatchTableMethods;
        }
        if (this.getWrapped() instanceof BaseLayerType) {
            this.dispatchTableMethods = Set.of();
            return this.dispatchTableMethods;
        }
        HashSet<AnalysisMethod> resultSet = new HashSet<AnalysisMethod>();
        for (ResolvedJavaMethod m : this.getWrapped().getDeclaredMethods(false)) {
            assert (!m.isConstructor()) : Assertions.errorMessage((Object[])new Object[]{"Unexpected constructor", m});
            if (m.isStatic()) continue;
            try {
                AnalysisMethod aMethod = this.universe.lookup((JavaMethod)m);
                assert (aMethod != null) : m;
                resultSet.add(aMethod);
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                // empty catch block
            }
        }
        VarHandle.storeStoreFence();
        this.dispatchTableMethods = resultSet;
        return this.dispatchTableMethods;
    }

    public AnalysisMethod findMethod(String name, Signature signature) {
        for (AnalysisMethod method : this.getDeclaredMethods(false)) {
            if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public AnalysisMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public void link() {
        this.wrapped.link();
    }

    public boolean hasDefaultMethods() {
        return this.wrapped.hasDefaultMethods();
    }

    public boolean declaresDefaultMethods() {
        return this.wrapped.declaresDefaultMethods();
    }

    public boolean isCloneableWithAllocation() {
        return this.isCloneableWithAllocation;
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    @Override
    public AnalysisUniverse getUniverse() {
        return this.universe;
    }

    @Override
    public int compareTo(AnalysisType other) {
        return Integer.compare(this.id, other.id);
    }

    public int hashCode() {
        assert (this.id != 0 || this.isJavaLangObject()) : "Type id not set yet";
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public void addInstanceFieldsInterceptor(InstanceFieldsInterceptor interceptor) {
        ConcurrentLightHashSet.addElement(this, INTERCEPTORS_UPDATER, interceptor);
    }

    private ResolvedJavaField[] interceptInstanceFields(ResolvedJavaField[] fields) {
        ResolvedJavaField[] result = fields;
        for (Object interceptor : ConcurrentLightHashSet.getElements(this, INTERCEPTORS_UPDATER)) {
            result = ((InstanceFieldsInterceptor)interceptor).interceptInstanceFields(this.universe, result, this);
        }
        return result;
    }

    public static interface InstanceFieldsInterceptor {
        public ResolvedJavaField[] interceptInstanceFields(AnalysisUniverse var1, ResolvedJavaField[] var2, AnalysisType var3);
    }
}

