/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.ModifiersProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

public abstract class AnalysisElement
implements AnnotatedElement {
    private static final AtomicReferenceFieldUpdater<AnalysisElement, Object> reachableNotificationsUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisElement.class, Object.class, "elementReachableNotifications");
    private volatile Object elementReachableNotifications;

    public abstract AnnotatedElement getWrapped();

    protected abstract AnalysisUniverse getUniverse();

    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getUniverse().getAnnotationExtractor().hasAnnotation(this.getWrapped(), annotationClass);
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getUniverse().getAnnotationExtractor().extractAnnotation(this.getWrapped(), annotationClass, false);
    }

    @Override
    public final <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        return (T)this.getUniverse().getAnnotationExtractor().extractAnnotation(this.getWrapped(), annotationClass, true);
    }

    @Override
    public final Annotation[] getAnnotations() {
        throw GraalError.shouldNotReachHere((String)"Getting all annotations is not supported because it initializes all annotation classes and their dependencies");
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        throw GraalError.shouldNotReachHere((String)"Getting all annotations is not supported because it initializes all annotation classes and their dependencies");
    }

    public void registerReachabilityNotification(ElementNotification notification) {
        ConcurrentLightHashSet.addElement(this, reachableNotificationsUpdater, notification);
    }

    public void notifyReachabilityCallback(AnalysisUniverse universe, ElementNotification notification) {
        notification.notifyCallback(universe, this);
        ConcurrentLightHashSet.removeElement(this, reachableNotificationsUpdater, notification);
    }

    protected void notifyReachabilityCallbacks(AnalysisUniverse universe, List<AnalysisFuture<Void>> futures) {
        ConcurrentLightHashSet.forEach(this, reachableNotificationsUpdater, c -> futures.add(c.notifyCallback(universe, this)));
        ConcurrentLightHashSet.removeElementIf(this, reachableNotificationsUpdater, ElementNotification::isNotified);
    }

    public abstract boolean isReachable();

    protected abstract void onReachable(Object var1);

    public abstract boolean isTrackedAcrossLayers();

    public boolean isTriggered() {
        return this.isReachable();
    }

    protected static void execute(AnalysisUniverse universe, Runnable task) {
        universe.getBigbang().postTask(d -> task.run());
    }

    private static void execute(AnalysisUniverse universe, AnalysisFuture<?> task) {
        universe.getBigbang().postTask(d -> task.ensureDone());
    }

    boolean isValidReason(Object reason) {
        if (reason == null) {
            return false;
        }
        if (reason instanceof String) {
            String s = (String)reason;
            return !s.isEmpty();
        }
        return reason instanceof AnalysisElement || reason instanceof ModifiersProvider || reason instanceof ObjectScanner.ScanReason || reason instanceof BytecodePosition;
    }

    public static final class ElementNotification {
        private final Consumer<Feature.DuringAnalysisAccess> callback;
        private final AtomicReference<AnalysisFuture<Void>> notified = new AtomicReference();

        public ElementNotification(Consumer<Feature.DuringAnalysisAccess> callback) {
            this.callback = callback;
        }

        public boolean isNotified() {
            return this.notified.get() != null;
        }

        AnalysisFuture<Void> notifyCallback(AnalysisUniverse universe, AnalysisElement triggeredElement) {
            assert (triggeredElement.isTriggered()) : triggeredElement;
            AnalysisFuture<Void> existing = this.notified.get();
            if (existing != null) {
                return existing;
            }
            AnalysisFuture<Void> newValue = new AnalysisFuture<Void>(() -> {
                this.callback.accept(universe.getConcurrentAnalysisAccess());
                return null;
            });
            existing = this.notified.compareAndExchange(null, newValue);
            if (existing != null) {
                return existing;
            }
            AnalysisElement.execute(universe, newValue);
            return newValue;
        }
    }

    public static class ReachabilityTraceBuilder {
        private final String header;
        private final Object rootReason;
        private final BigBang bb;
        private final StringBuilder reasonTrace;
        private final ArrayDeque<Object> reasonStack;
        private final HashSet<Object> seen;
        static boolean indentAllLines = true;

        ReachabilityTraceBuilder(String traceHeader, Object reason, BigBang bigBang) {
            this.header = traceHeader;
            this.rootReason = reason;
            this.bb = bigBang;
            this.reasonTrace = new StringBuilder();
            this.reasonStack = new ArrayDeque();
            this.seen = new HashSet();
        }

        public static String buildReachabilityTrace(BigBang bb, Object reason, String header) {
            ReachabilityTraceBuilder builder = new ReachabilityTraceBuilder(header, reason, bb);
            builder.build();
            return builder.reasonTrace.toString();
        }

        public static String buildReachabilityTrace(BigBang bb, Object reason) {
            ReachabilityTraceBuilder builder = new ReachabilityTraceBuilder("Reached by", reason, bb);
            builder.build();
            return builder.reasonTrace.toString();
        }

        private void build() {
            this.reasonTrace.append(this.header);
            this.maybeExpandReasonStack(this.rootReason);
            Object indent = "    ";
            String prevIndent = indent;
            while (!this.reasonStack.isEmpty()) {
                boolean expanded;
                Object top = this.reasonStack.peekLast();
                if (top instanceof CompoundReason) {
                    Object next;
                    CompoundReason compoundReason = (CompoundReason)top;
                    if (compoundReason.isFirst()) {
                        compoundReason.storeCurrentIndent((String)indent);
                    }
                    if ((next = compoundReason.next()) != null) {
                        indent = compoundReason.getIndent() + (compoundReason.hasNext() ? "\u2502   " : "    ");
                        String infix = compoundReason.hasNext() ? "\u251c\u2500\u2500 " : "\u2514\u2500\u2500 ";
                        expanded = this.processReason(next, compoundReason.getIndent() + infix);
                    } else {
                        this.reasonStack.removeLast();
                        expanded = false;
                        if (indentAllLines) {
                            prevIndent = compoundReason.getIndent();
                        } else {
                            indent = compoundReason.getIndent();
                        }
                    }
                } else {
                    expanded = this.processReason(this.reasonStack.pollLast(), (String)indent);
                }
                if (!indentAllLines) continue;
                if (expanded) {
                    prevIndent = indent;
                    indent = (String)indent + "    ";
                    continue;
                }
                indent = prevIndent;
            }
        }

        private boolean processReason(Object current, String prefix) {
            Object reasonStr;
            boolean expanded = false;
            if (current instanceof String) {
                reasonStr = "str: " + String.valueOf(current);
            } else if (current instanceof AnalysisMethod) {
                AnalysisMethod method = (AnalysisMethod)current;
                reasonStr = "at " + method.format("%f method %H.%n(%p)") + ", " + ReachabilityTraceBuilder.methodReasonStr(method);
                expanded = this.methodReason((AnalysisMethod)current);
            } else if (current instanceof AnalysisField) {
                AnalysisField field = (AnalysisField)current;
                reasonStr = "field " + field.format("%H.%n") + " " + ReachabilityTraceBuilder.fieldReasonStr(field);
                expanded = this.fieldReason(field);
            } else if (current instanceof AnalysisType) {
                AnalysisType type = (AnalysisType)current;
                reasonStr = "type " + type.toJavaName() + " " + ReachabilityTraceBuilder.typeReasonStr(type);
                expanded = this.typeReason(type);
            } else if (current instanceof ResolvedJavaMethod) {
                reasonStr = ((ResolvedJavaMethod)current).format("%f method %H.%n");
            } else if (current instanceof ResolvedJavaField) {
                ResolvedJavaField field = (ResolvedJavaField)current;
                AnalysisField analysisField = this.bb.getUniverse().lookup((JavaField)field);
                if (analysisField != null) {
                    return this.processReason(analysisField, prefix);
                }
                reasonStr = "field " + ((ResolvedJavaField)current).format("%H.%n");
            } else if (current instanceof ResolvedJavaType) {
                reasonStr = "type " + ((ResolvedJavaType)current).getName();
            } else if (current instanceof BytecodePosition) {
                BytecodePosition position = (BytecodePosition)current;
                ResolvedJavaMethod method = position.getMethod();
                reasonStr = "at " + method.format("%f") + " method " + String.valueOf(method.asStackTraceElement(position.getBCI())) + ", " + ReachabilityTraceBuilder.methodReasonStr(method);
                expanded = this.methodReason(position.getMethod());
            } else if (current instanceof ObjectScanner.MethodParsing) {
                ObjectScanner.MethodParsing methodParsing = (ObjectScanner.MethodParsing)current;
                AnalysisMethod method = methodParsing.getMethod();
                reasonStr = "at " + method.format("%f method %H.%n(%p)") + ", " + ReachabilityTraceBuilder.methodReasonStr(method);
                expanded = this.methodReason(methodParsing.getMethod());
            } else if (current instanceof ObjectScanner.ScanReason) {
                ObjectScanner.ScanReason scanReason = (ObjectScanner.ScanReason)current;
                reasonStr = scanReason.toString(this.bb);
                expanded = this.maybeExpandReasonStack(scanReason.getPrevious());
            } else {
                throw AnalysisError.shouldNotReachHere("Unknown reachability reason.");
            }
            this.print(prefix, (String)reasonStr);
            return expanded;
        }

        private void print(String prefix, String reasonStr) {
            String reasonStr2 = String.join((CharSequence)(System.lineSeparator() + prefix), (CharSequence[])reasonStr.lines().toArray(String[]::new));
            this.reasonTrace.append(System.lineSeparator()).append(prefix).append(reasonStr2);
        }

        private boolean typeReason(AnalysisType type) {
            if (type.isInstantiated()) {
                return this.maybeExpandReasonStack(type.getInstantiatedReason());
            }
            return this.maybeExpandReasonStack(type.getReachableReason());
        }

        private static String typeReasonStr(AnalysisType type) {
            if (type.isInstantiated()) {
                return "is marked as instantiated";
            }
            return "is reachable";
        }

        private boolean fieldReason(AnalysisField field) {
            if (field.getWrittenReason() != null) {
                return this.maybeExpandReasonStack(field.getWrittenReason());
            }
            if (field.getReadReason() != null) {
                return this.maybeExpandReasonStack(field.getReadReason());
            }
            if (field.getAccessedReason() != null) {
                return this.maybeExpandReasonStack(field.getAccessedReason());
            }
            if (field.getFoldedReason() != null) {
                return this.maybeExpandReasonStack(field.getFoldedReason());
            }
            return false;
        }

        private static String fieldReasonStr(AnalysisField field) {
            if (field.getWrittenReason() != null) {
                return "is written";
            }
            if (field.getReadReason() != null) {
                return "is read";
            }
            if (field.getAccessedReason() != null) {
                return "is accessed";
            }
            if (field.getFoldedReason() != null) {
                return "is folded";
            }
            return "";
        }

        private boolean methodReason(ResolvedJavaMethod method) {
            if (method instanceof AnalysisMethod) {
                AnalysisMethod aMethod = (AnalysisMethod)method;
                if (aMethod.isSimplyImplementationInvoked()) {
                    if (aMethod.isStatic()) {
                        return this.maybeExpandReasonStack(aMethod.getImplementationInvokedReason());
                    }
                    return this.maybeExpandReasonStack(new CompoundReason(aMethod.getImplementationInvokedReason(), aMethod.getDeclaringClass()));
                }
                if (aMethod.isInlined()) {
                    if (aMethod.isStatic()) {
                        return this.maybeExpandReasonStack(aMethod.getInlinedReason());
                    }
                    return this.maybeExpandReasonStack(new CompoundReason(aMethod.getInlinedReason(), aMethod.getDeclaringClass()));
                }
                if (aMethod.isIntrinsicMethod()) {
                    return this.maybeExpandReasonStack(aMethod.getIntrinsicMethodReason());
                }
                return this.maybeExpandReasonStack(aMethod.getInvokedReason());
            }
            return false;
        }

        private boolean maybeExpandReasonStack(Object reason) {
            if (reason != null && this.seen.add(reason)) {
                return this.reasonStack.add(reason);
            }
            return false;
        }

        private static String methodReasonStr(ResolvedJavaMethod method) {
            if (method instanceof AnalysisMethod) {
                AnalysisMethod aMethod = (AnalysisMethod)method;
                if (aMethod.isSimplyImplementationInvoked()) {
                    if (aMethod.isStatic()) {
                        return "implementation invoked";
                    }
                    AnalysisType declaringClass = aMethod.getDeclaringClass();
                    assert (declaringClass.isInstantiated() || declaringClass.isAbstract() || declaringClass.isInterface() && aMethod.isDefault() || declaringClass.isReachable()) : String.valueOf(declaringClass) + " is not reachable";
                    return "implementation invoked";
                }
                if (aMethod.isInlined()) {
                    if (aMethod.isStatic()) {
                        return "inlined";
                    }
                    AnalysisType declaringClass = aMethod.getDeclaringClass();
                    assert (declaringClass.isInstantiated() || declaringClass.isAbstract() || declaringClass.isInterface() && aMethod.isDefault() || declaringClass.isReachable()) : String.valueOf(declaringClass) + " is not reachable";
                    return "inlined";
                }
                if (aMethod.isIntrinsicMethod()) {
                    return "intrinsified";
                }
            }
            return "<no available reason>";
        }

        static class CompoundReason {
            final Object[] reasons;
            int index = 0;
            String indent;

            CompoundReason(Object ... reasons) {
                this.reasons = reasons;
            }

            boolean isFirst() {
                return this.index == 0;
            }

            Object next() {
                return this.index < this.reasons.length ? this.reasons[this.index++] : null;
            }

            boolean hasNext() {
                return this.index < this.reasons.length;
            }

            public void storeCurrentIndent(String indentStr) {
                this.indent = indentStr;
            }

            public String getIndent() {
                return this.indent;
            }
        }
    }

    public static class ReachabilityReason {
    }

    public static final class MethodOverrideReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Executable> callback;
        private final Set<AnalysisMethod> seenOverride = ConcurrentHashMap.newKeySet();

        public MethodOverrideReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Executable> callback) {
            this.callback = callback;
        }

        public void notifyCallback(AnalysisUniverse universe, AnalysisMethod reachableOverride) {
            Executable javaMethod;
            assert (reachableOverride.isReachable()) : reachableOverride;
            if (this.seenOverride.add(reachableOverride) && (javaMethod = reachableOverride.getJavaMethod()) != null) {
                AnalysisElement.execute(universe, () -> this.callback.accept(universe.getConcurrentAnalysisAccess(), javaMethod));
            }
        }
    }

    public static final class SubtypeReachableNotification {
        private final BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback;
        private final Map<AnalysisType, AnalysisFuture<Void>> seenSubtypes = new ConcurrentHashMap<AnalysisType, AnalysisFuture<Void>>();

        public SubtypeReachableNotification(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> callback) {
            this.callback = callback;
        }

        public AnalysisFuture<Void> notifyCallback(AnalysisUniverse universe, AnalysisType reachableSubtype) {
            assert (reachableSubtype.isReachable()) : reachableSubtype;
            return this.seenSubtypes.computeIfAbsent(reachableSubtype, k -> {
                AnalysisFuture<Void> newValue = new AnalysisFuture<Void>(() -> {
                    this.callback.accept(universe.getConcurrentAnalysisAccess(), reachableSubtype.getJavaClass());
                    return null;
                });
                AnalysisElement.execute(universe, newValue);
                return newValue;
            });
        }
    }
}

