/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.heap.value;

import com.oracle.graal.pointsto.heap.value.EagerValueSupplier;
import com.oracle.graal.pointsto.heap.value.LazyValueSupplier;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public interface ValueSupplier<V> {
    public static <V> ValueSupplier<V> eagerValue(V value) {
        return new EagerValueSupplier<V>(Objects.requireNonNull(value));
    }

    public static <V> ValueSupplier<V> lazyValue(Supplier<V> valueSupplier, BooleanSupplier isAvailable) {
        return new LazyValueSupplier<V>(valueSupplier, isAvailable);
    }

    public boolean isAvailable();

    public V get();
}

